/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.awt.screen;

import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.util.Optional;

public class GraphicsDeviceExtensions {
    public static GraphicsDevice[] getAvailableScreens() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDevices = graphicsEnvironment.getScreenDevices();
        return graphicsDevices;
    }

    public static Optional<GraphicsDevice> getGraphicsDevice(int index) {
        if (GraphicsDeviceExtensions.isScreenAvailableToShow(index)) {
            GraphicsDevice[] graphicsDevices = GraphicsDeviceExtensions.getAvailableScreens();
            return Optional.of(graphicsDevices[index]);
        }
        return Optional.empty();
    }

    public static int getGraphicsDeviceIndexIsShowingOn(Component component) {
        int graphicsDeviceIndex = -1;
        GraphicsDevice graphicsDevice = GraphicsDeviceExtensions.getGraphicsDeviceIsShowingOn(component);
        GraphicsDevice[] graphicsDevices = GraphicsDeviceExtensions.getAvailableScreens();
        for (int i = 0; i < graphicsDevices.length; ++i) {
            if (!graphicsDevices[i].equals(graphicsDevice)) continue;
            graphicsDeviceIndex = i;
            break;
        }
        return graphicsDeviceIndex;
    }

    public static GraphicsDevice getGraphicsDeviceIsShowingOn(Component component) {
        GraphicsDevice graphicsDevice = component.getGraphicsConfiguration().getDevice();
        return graphicsDevice;
    }

    public static boolean isScreenAvailableToShow(int screen) {
        GraphicsDevice[] graphicsDevices = GraphicsDeviceExtensions.getAvailableScreens();
        return graphicsDevices.length > 0 && screen > -1 && screen < graphicsDevices.length;
    }

    public static <T extends Window> void showOnScreen(int screen, T window) {
        if (GraphicsDeviceExtensions.isScreenAvailableToShow(screen)) {
            GraphicsDevice[] graphicsDevices = GraphicsDeviceExtensions.getAvailableScreens();
            graphicsDevices[screen].setFullScreenWindow(window);
        }
    }
}

