/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.awt.screen;

import io.github.astrapi69.awt.extension.AwtExtensions;
import io.github.astrapi69.awt.screen.GraphicsDeviceExtensions;
import io.github.astrapi69.awt.screen.position.ComponentPositionModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import lombok.NonNull;

public class ScreenSizeExtensions {
    public static void maximize(@NonNull Component component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        ScreenSizeExtensions.maximize(AwtExtensions.getWindowForComponent(component));
    }

    public static void maximize(@NonNull Window window) {
        if (window == null) {
            throw new NullPointerException("window is marked non-null but is null");
        }
        window.setSize(ScreenSizeExtensions.getScreenWidth(window), ScreenSizeExtensions.getScreenHeight(window));
    }

    public static void centralize(@NonNull Component component, int divideScreenWith, int divideScreenHeight) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        Window window = AwtExtensions.getWindowForComponent(component);
        ScreenSizeExtensions.centralize(window, divideScreenWith, divideScreenHeight);
    }

    public static void centralize(@NonNull Window window, int divideScreenWith, int divideScreenHeight) {
        if (window == null) {
            throw new NullPointerException("window is marked non-null but is null");
        }
        int x = ScreenSizeExtensions.getScreenWidth(window);
        int y = ScreenSizeExtensions.getScreenHeight(window);
        int width = x;
        int height = y;
        window.setLocation(width / divideScreenWith, height / divideScreenHeight);
        window.setSize(width / divideScreenWith, height / divideScreenHeight);
    }

    public static List<Point> computeDialogPositions(int dialogWidth, int dialogHeight) {
        ArrayList<Point> dialogPosition = null;
        int windowBesides = ScreenSizeExtensions.getScreenWidth() / dialogWidth;
        int windowBelow = ScreenSizeExtensions.getScreenHeight() / dialogHeight;
        int listSize = windowBesides * windowBelow;
        dialogPosition = new ArrayList<Point>(listSize);
        int dotWidth = 0;
        int dotHeight = 0;
        for (int y = 0; y < windowBelow; ++y) {
            dotWidth = 0;
            for (int x = 0; x < windowBesides; ++x) {
                Point p = new Point(dotWidth, dotHeight);
                dialogPosition.add(p);
                dotWidth += dialogWidth;
            }
            dotHeight += dialogHeight;
        }
        return dialogPosition;
    }

    public static int getFirstScreenHeight() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDevices = graphicsEnvironment.getScreenDevices();
        int height = ScreenSizeExtensions.getScreenHeight();
        for (GraphicsDevice graphicsDevice : graphicsDevices) {
            GraphicsConfiguration[] graphicsConfigurations = graphicsDevice.getConfigurations();
            GraphicsConfiguration graphicsConfiguration = ScreenSizeExtensions.getFirst(graphicsConfigurations);
            if (graphicsConfiguration == null) continue;
            height = (int)ScreenSizeExtensions.getScreenHeight(graphicsConfiguration);
            break;
        }
        return height;
    }

    public static int getFirstScreenWidth() {
        GraphicsDevice[] graphicsDevices = ScreenSizeExtensions.getScreenDevices();
        int width = ScreenSizeExtensions.getScreenWidth();
        for (GraphicsDevice graphicsDevice : graphicsDevices) {
            GraphicsConfiguration[] graphicsConfigurations = graphicsDevice.getConfigurations();
            GraphicsConfiguration graphicsConfiguration = ScreenSizeExtensions.getFirst(graphicsConfigurations);
            if (graphicsConfiguration == null) continue;
            width = (int)ScreenSizeExtensions.getScreenWidth(graphicsConfiguration);
            break;
        }
        return width;
    }

    public static GraphicsConfiguration getGraphicsConfiguration(int screenID) {
        return ScreenSizeExtensions.getScreenDevice(screenID).getDefaultConfiguration();
    }

    public static Point getPoint() {
        Point p = new Point(ScreenSizeExtensions.getScreenWidth(), ScreenSizeExtensions.getScreenHeight());
        return p;
    }

    public static GraphicsDevice getScreenDevice(int screenID) {
        return ScreenSizeExtensions.getScreenDevices()[screenID];
    }

    public static GraphicsDevice[] getScreenDevices() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        return gs;
    }

    public static Dimension getScreenDimension(Component component) {
        int screenID = ScreenSizeExtensions.getScreenID(component);
        Dimension dimension = new Dimension(0, 0);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration defaultConfiguration = ge.getScreenDevices()[screenID].getDefaultConfiguration();
        Rectangle rectangle = defaultConfiguration.getBounds();
        dimension.setSize(rectangle.getWidth(), rectangle.getHeight());
        return dimension;
    }

    public static int getScreenHeight() {
        int y = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        return y;
    }

    public static Dimension getScreenSizeDimension() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static int getScreenHeight(Component component) {
        Dimension dimension = ScreenSizeExtensions.getScreenDimension(component);
        return dimension.height;
    }

    public static double getScreenHeight(GraphicsConfiguration graphicsConfiguration) {
        Rectangle bounds = graphicsConfiguration.getBounds();
        double height = bounds.getHeight();
        return height;
    }

    public static int getScreenHeight(GraphicsDevice graphicsDevice) {
        GraphicsConfiguration[] graphicsConfigurations = graphicsDevice.getConfigurations();
        GraphicsConfiguration graphicsConfiguration = ScreenSizeExtensions.getFirst(graphicsConfigurations);
        if (graphicsConfiguration != null) {
            double height = ScreenSizeExtensions.getScreenHeight(graphicsConfiguration);
            return (int)height;
        }
        return ScreenSizeExtensions.getScreenHeight();
    }

    public static int getScreenID(Component component) {
        return GraphicsDeviceExtensions.getGraphicsDeviceIndexIsShowingOn(component);
    }

    public static int getScreenWidth() {
        int x = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        return x;
    }

    public static int getScreenWidth(Component component) {
        Dimension dimension = ScreenSizeExtensions.getScreenDimension(component);
        return dimension.width;
    }

    public static double getScreenWidth(GraphicsConfiguration graphicsConfiguration) {
        Rectangle bounds = graphicsConfiguration.getBounds();
        return bounds.getWidth();
    }

    public static int getScreenWidth(GraphicsDevice graphicsDevice) {
        GraphicsConfiguration[] graphicsConfigurations = graphicsDevice.getConfigurations();
        GraphicsConfiguration graphicsConfiguration = ScreenSizeExtensions.getFirst(graphicsConfigurations);
        if (graphicsConfiguration != null) {
            return (int)ScreenSizeExtensions.getScreenWidth(graphicsConfiguration);
        }
        return ScreenSizeExtensions.getScreenWidth();
    }

    public static void showFrame(@NonNull Frame frame) {
        if (frame == null) {
            throw new NullPointerException("frame is marked non-null but is null");
        }
        frame.setVisible(true);
        if (!frame.isActive()) {
            frame.toFront();
        }
    }

    public static void setDefaultFrameSize(@NonNull Frame frame) {
        if (frame == null) {
            throw new NullPointerException("frame is marked non-null but is null");
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        frame.setSize(ScreenSizeExtensions.getScreenWidth(gs[0]), ScreenSizeExtensions.getScreenHeight(gs[0]));
    }

    public static void toggleFullScreen(@NonNull JFrame frame) {
        if (frame == null) {
            throw new NullPointerException("frame is marked non-null but is null");
        }
        GraphicsDevice device = frame.getGraphicsConfiguration().getDevice();
        frame.setExtendedState(6);
        if (frame.equals(device.getFullScreenWindow())) {
            device.setFullScreenWindow(null);
        } else {
            frame.setVisible(true);
            device.setFullScreenWindow(frame);
        }
    }

    public static void setComponentPosition(Component component, ComponentPositionModel componentPositionModel) {
        component.setPreferredSize(new Dimension(componentPositionModel.getWidth(), componentPositionModel.getHeight()));
        component.setLocation(componentPositionModel.getXPosition(), componentPositionModel.getYPosition());
        component.setSize(componentPositionModel.getWidth(), componentPositionModel.getHeight());
    }

    private static <T> T getFirst(T[] array) {
        if (array != null && array.length != 0) {
            return array[0];
        }
        return null;
    }
}

