/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.awt.screen.position;

import io.github.astrapi69.awt.screen.ScreenSizeExtensions;
import io.github.astrapi69.awt.screen.position.ComponentPositionModel;
import io.github.astrapi69.awt.screen.position.ComponentPositionPreference;
import java.awt.Component;
import java.awt.Point;
import java.util.prefs.Preferences;
import lombok.NonNull;

public class ComponentPositionStore {
    Component component;
    Class<?> clazz;
    String widthKey;
    String heightKey;
    String xPositionKey;
    String yPositionKey;
    int defaultWidth;
    int defaultHeight;

    public ComponentPositionStore(@NonNull Component component, @NonNull Class<?> clazz) {
        this(component, clazz, 500, 500);
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
    }

    public ComponentPositionStore(@NonNull Component component, @NonNull Class<?> clazz, int defaultWidth, int defaultHeight) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        this.defaultWidth = defaultWidth;
        this.defaultHeight = defaultHeight;
        this.component = component;
        this.clazz = clazz;
        this.widthKey = clazz.getSimpleName() + ComponentPositionPreference.WIDTH.getKey();
        this.heightKey = clazz.getSimpleName() + ComponentPositionPreference.HEIGHT.getKey();
        this.xPositionKey = clazz.getSimpleName() + ComponentPositionPreference.X_POSITION.getKey();
        this.yPositionKey = clazz.getSimpleName() + ComponentPositionPreference.Y_POSITION.getKey();
    }

    public void restorePosition() {
        Preferences preferences = Preferences.userNodeForPackage(this.clazz);
        int width = preferences.getInt(this.widthKey, this.defaultWidth);
        int height = preferences.getInt(this.heightKey, this.defaultHeight);
        int xPosition = (ScreenSizeExtensions.getScreenWidth() - width) / 2;
        int yPosition = (ScreenSizeExtensions.getScreenHeight() - height) / 2;
        xPosition = preferences.getInt(this.xPositionKey, xPosition);
        yPosition = preferences.getInt(this.yPositionKey, yPosition);
        Object componentPositionModel = ((ComponentPositionModel.ComponentPositionModelBuilder)((ComponentPositionModel.ComponentPositionModelBuilder)((ComponentPositionModel.ComponentPositionModelBuilder)((ComponentPositionModel.ComponentPositionModelBuilder)ComponentPositionModel.builder().width(width)).height(height)).xPosition(xPosition)).yPosition(yPosition)).build();
        ScreenSizeExtensions.setComponentPosition(this.component, componentPositionModel);
    }

    public void storePosition() {
        Point location = this.component.getLocation();
        Preferences preferences = Preferences.userNodeForPackage(this.clazz);
        int width = this.component.getWidth();
        int height = this.component.getHeight();
        int xPosition = (int)location.getX();
        int yPosition = (int)location.getY();
        preferences.putInt(this.widthKey, width);
        preferences.putInt(this.heightKey, height);
        preferences.putInt(this.xPositionKey, xPosition);
        preferences.putInt(this.yPositionKey, yPosition);
    }
}

