/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.awt.system;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionListener;
import java.util.Map;
import lombok.NonNull;

public class SystemTrayFactory {
    public static SystemTray newSystemTray(@NonNull TrayIcon trayIcon, @NonNull PopupMenu popupMenu) throws AWTException {
        if (trayIcon == null) {
            throw new NullPointerException("trayIcon is marked non-null but is null");
        }
        if (popupMenu == null) {
            throw new NullPointerException("popupMenu is marked non-null but is null");
        }
        if (!SystemTray.isSupported()) {
            throw new RuntimeException("SystemTray is not supported");
        }
        SystemTray systemTray = SystemTray.getSystemTray();
        trayIcon.setPopupMenu(popupMenu);
        systemTray.add(trayIcon);
        return systemTray;
    }

    public static TrayIcon newTrayIcon(String imgFilename, String appName, PopupMenu systemTrayPopupMenu, Map<String, ActionListener> actionListeners) {
        Image image = Toolkit.getDefaultToolkit().getImage(imgFilename);
        TrayIcon trayIcon = new TrayIcon(image, appName, systemTrayPopupMenu);
        for (Map.Entry<String, ActionListener> actionListener : actionListeners.entrySet()) {
            trayIcon.setActionCommand(actionListener.getKey());
            trayIcon.addActionListener(actionListener.getValue());
        }
        return trayIcon;
    }
}

