/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.bean.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public interface BeanMapper<ENTITY, DTO> {
    public DTO toDto(ENTITY var1);

    default public List<DTO> toDtos(Collection<ENTITY> entities) {
        Objects.requireNonNull(entities);
        ArrayList<DTO> domainObjects = new ArrayList<DTO>();
        if (!entities.isEmpty()) {
            for (ENTITY entity : entities) {
                domainObjects.add(this.toDto(entity));
            }
        }
        return domainObjects;
    }

    default public List<DTO> toDtos(Iterable<ENTITY> entities) {
        Objects.requireNonNull(entities);
        ArrayList<DTO> domainObjects = new ArrayList<DTO>();
        for (ENTITY entity : entities) {
            domainObjects.add(this.toDto(entity));
        }
        return domainObjects;
    }

    default public List<ENTITY> toEntities(Collection<DTO> dtos) {
        Objects.requireNonNull(dtos);
        ArrayList<ENTITY> entities = new ArrayList<ENTITY>();
        if (!dtos.isEmpty()) {
            for (DTO dto : dtos) {
                entities.add(this.toEntity(dto));
            }
        }
        return entities;
    }

    default public List<ENTITY> toEntities(Iterable<DTO> dtos) {
        Objects.requireNonNull(dtos);
        ArrayList<ENTITY> entities = new ArrayList<ENTITY>();
        for (DTO dto : dtos) {
            entities.add(this.toEntity(dto));
        }
        return entities;
    }

    public ENTITY toEntity(DTO var1);
}

