/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.checksum;

import io.github.astrapi69.crypt.api.algorithm.Algorithm;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.Adler32;
import java.util.zip.CRC32;

public final class ByteArrayChecksumExtensions {
    private ByteArrayChecksumExtensions() {
    }

    public static String getChecksum(byte[] bytes, Algorithm algorithm) throws NoSuchAlgorithmException {
        return ByteArrayChecksumExtensions.getChecksum(bytes, algorithm.getAlgorithm());
    }

    public static String getChecksum(byte[] bytes, String algorithm) throws NoSuchAlgorithmException {
        return ByteArrayChecksumExtensions.getChecksum(algorithm, (byte[][])new byte[][]{bytes});
    }

    public static String getChecksum(Byte[] bytes, Algorithm algorithm) throws NoSuchAlgorithmException {
        return ByteArrayChecksumExtensions.getChecksum(bytes, algorithm.getAlgorithm());
    }

    public static String getChecksum(Byte[] bytes, String algorithm) throws NoSuchAlgorithmException {
        return ByteArrayChecksumExtensions.getChecksum(ByteArrayChecksumExtensions.toByteArray(bytes), algorithm);
    }

    public static String getChecksum(Algorithm algorithm, byte[] ... byteArrays) throws NoSuchAlgorithmException {
        return ByteArrayChecksumExtensions.getChecksum(algorithm.getAlgorithm(), byteArrays);
    }

    public static String getChecksum(String algorithm, byte[] ... byteArrays) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        messageDigest.reset();
        for (byte[] byteArray : byteArrays) {
            messageDigest.update(byteArray);
        }
        return ByteArrayChecksumExtensions.encodeHex(messageDigest.digest());
    }

    public static long getCheckSumAdler32(byte[] bytes) {
        Adler32 checksum = new Adler32();
        checksum.update(bytes, 0, bytes.length);
        return checksum.getValue();
    }

    public static String getCheckSumAdler32HexString(byte[] bytes) {
        return Long.toHexString(ByteArrayChecksumExtensions.getCheckSumAdler32(bytes));
    }

    public static long getCheckSumCRC32(byte[] bytes) {
        CRC32 checksum = new CRC32();
        checksum.update(bytes, 0, bytes.length);
        return checksum.getValue();
    }

    public static String getCheckSumCRC32HexString(byte[] bytes) {
        return ByteArrayChecksumExtensions.normalizeCheckSumCRC32HexStringLength(Long.toHexString(ByteArrayChecksumExtensions.getCheckSumCRC32(bytes)));
    }

    public static String encodeHex(byte[] bytes) {
        StringBuilder hexView = new StringBuilder();
        for (byte currentByte : bytes) {
            String intAsHex = Integer.toHexString(0xFF & currentByte);
            if (intAsHex.length() == 1) {
                hexView.append('0');
            }
            hexView.append(intAsHex);
        }
        return hexView.toString();
    }

    private static byte[] toByteArray(Byte[] bytes) {
        byte[] byteArray = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            byteArray[i] = bytes[i];
        }
        return byteArray;
    }

    private static String normalizeCheckSumCRC32HexStringLength(String hexString) {
        StringBuilder hexStringBuilder = new StringBuilder(hexString);
        while (hexStringBuilder.length() != 8) {
            hexStringBuilder.insert(0, "0");
        }
        hexString = hexStringBuilder.toString();
        return hexString;
    }
}

