/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.checksum;

import io.github.astrapi69.checksum.ByteArrayChecksumExtensions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public class DirectoryChecksum {
    MessageDigest messageDigest;

    DirectoryChecksum(String algorithm) throws NoSuchAlgorithmException {
        Objects.requireNonNull(algorithm, "Given algorithm is null");
        this.messageDigest = MessageDigest.getInstance(algorithm);
        this.messageDigest.reset();
    }

    public String update(Path dirPath) throws IOException {
        Files.newDirectoryStream(dirPath).forEach(currentFile -> {
            if (!Files.isDirectory(currentFile, new LinkOption[0])) {
                try {
                    this.messageDigest.update(Files.readAllBytes(currentFile));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                this.update((Path)currentFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return ByteArrayChecksumExtensions.encodeHex(this.messageDigest.digest());
    }
}

