/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.checksum;

import io.github.astrapi69.checksum.ByteArrayChecksumExtensions;
import io.github.astrapi69.checksum.DirectoryChecksum;
import io.github.astrapi69.crypt.api.algorithm.Algorithm;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.NoSuchAlgorithmException;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;

public final class FileChecksumExtensions {
    private FileChecksumExtensions() {
    }

    public static String getChecksum(File file, Algorithm algorithm) throws NoSuchAlgorithmException, IOException {
        return FileChecksumExtensions.getChecksum(file, algorithm.getAlgorithm());
    }

    public static long getChecksum(File file, boolean crc) throws IOException {
        try (CheckedInputStream cis = crc ? new CheckedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]), new CRC32()) : new CheckedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]), new Adler32());){
            long checksum;
            int length = (int)file.length();
            byte[] buffer = new byte[length];
            while (cis.read(buffer) >= 0) {
                checksum = cis.getChecksum().getValue();
            }
            long l = checksum = cis.getChecksum().getValue();
            return l;
        }
    }

    public static String getChecksum(File file, String algorithm) throws NoSuchAlgorithmException, IOException {
        if (file.isDirectory()) {
            DirectoryChecksum directoryChecksum = new DirectoryChecksum(algorithm);
            return directoryChecksum.update(file.toPath());
        }
        return ByteArrayChecksumExtensions.getChecksum(Files.readAllBytes(file.toPath()), algorithm);
    }

    public static long getCheckSumAdler32(File file) throws IOException {
        return ByteArrayChecksumExtensions.getCheckSumAdler32(Files.readAllBytes(file.toPath()));
    }

    public static String getCheckSumAdler32HexString(File file) throws IOException {
        return ByteArrayChecksumExtensions.getCheckSumAdler32HexString(Files.readAllBytes(file.toPath()));
    }

    public static long getCheckSumCRC32(File file) throws IOException {
        return ByteArrayChecksumExtensions.getCheckSumCRC32(Files.readAllBytes(file.toPath()));
    }

    public static String getCheckSumCRC32HexString(File file) throws IOException {
        return ByteArrayChecksumExtensions.getCheckSumCRC32HexString(Files.readAllBytes(file.toPath()));
    }
}

