/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.checksum;

import io.github.astrapi69.checksum.ByteArrayChecksumExtensions;
import io.github.astrapi69.crypt.api.algorithm.Algorithm;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public final class ObjectChecksumExtensions {
    private ObjectChecksumExtensions() {
    }

    public static <T extends Serializable> String getChecksum(T serializableObject, Algorithm algorithm) throws NoSuchAlgorithmException, IOException {
        return ObjectChecksumExtensions.getChecksum((String)algorithm.getAlgorithm(), (Serializable[])new Serializable[]{serializableObject});
    }

    public static <T extends Serializable> String getChecksum(T serializableObject, String algorithm) throws NoSuchAlgorithmException, IOException {
        return ObjectChecksumExtensions.getChecksum((String)algorithm, (Serializable[])new Serializable[]{serializableObject});
    }

    public static <T extends Serializable> long getChecksum(T serializableObject, boolean crc) throws IOException {
        return crc ? ByteArrayChecksumExtensions.getCheckSumCRC32(ObjectChecksumExtensions.toByteArray((Serializable[])new Serializable[]{serializableObject})) : ByteArrayChecksumExtensions.getCheckSumAdler32(ObjectChecksumExtensions.toByteArray((Serializable[])new Serializable[]{serializableObject}));
    }

    public static <T extends Serializable> String getChecksumHexString(T serializableObject, boolean crc) throws IOException {
        return crc ? ByteArrayChecksumExtensions.getCheckSumCRC32HexString(ObjectChecksumExtensions.toByteArray((Serializable[])new Serializable[]{serializableObject})) : ByteArrayChecksumExtensions.getCheckSumAdler32HexString(ObjectChecksumExtensions.toByteArray((Serializable[])new Serializable[]{serializableObject}));
    }

    @SafeVarargs
    public static <T extends Serializable> byte[] toByteArray(T ... objects) throws IOException {
        Objects.requireNonNull(objects);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
                for (T serializableObject : objects) {
                    objectOutputStream.writeObject(serializableObject);
                }
                objectOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }

    public static <T extends Serializable, E extends Serializable> String getChecksum(T serializableObject, E anotherSerializableObject, String algorithm) throws NoSuchAlgorithmException, IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(ObjectChecksumExtensions.toByteArray((Serializable[])new Serializable[]{serializableObject}));
        outputStream.write(ObjectChecksumExtensions.toByteArray((Serializable[])new Serializable[]{anotherSerializableObject}));
        return ByteArrayChecksumExtensions.getChecksum(outputStream.toByteArray(), algorithm);
    }

    @SafeVarargs
    public static <T extends Serializable> String getChecksum(String algorithm, T ... serializableObjects) throws NoSuchAlgorithmException, IOException {
        return ByteArrayChecksumExtensions.getChecksum(ObjectChecksumExtensions.toByteArray(serializableObjects), algorithm);
    }
}

