/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.checksum;

import io.github.astrapi69.checksum.ByteArrayChecksumExtensions;
import io.github.astrapi69.crypt.api.algorithm.Algorithm;
import java.security.NoSuchAlgorithmException;

public final class StringChecksumExtensions {
    private StringChecksumExtensions() {
    }

    public static String getChecksum(String text, Algorithm algorithm) throws NoSuchAlgorithmException {
        return StringChecksumExtensions.getChecksum(text, algorithm.getAlgorithm());
    }

    public static long getChecksum(String text, boolean crc) {
        return crc ? ByteArrayChecksumExtensions.getCheckSumCRC32(text.getBytes()) : ByteArrayChecksumExtensions.getCheckSumAdler32(text.getBytes());
    }

    public static String getChecksum(String text, String algorithm) throws NoSuchAlgorithmException {
        return ByteArrayChecksumExtensions.getChecksum(text.getBytes(), algorithm);
    }
}

