/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.comparator;

import io.github.astrapi69.comparator.ComparatorExtensions;
import java.io.Serializable;
import java.util.Comparator;

public class NullCheckComparator<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Comparator<T> decoratedComparator;
    private final boolean nullIsGreaterThan;

    public NullCheckComparator(Comparator<T> decoratedComparator) {
        this(decoratedComparator, false);
    }

    public NullCheckComparator(Comparator<T> decoratedComparator, boolean nullIsGreaterThan) {
        if (decoratedComparator == null) {
            throw new IllegalArgumentException("Given decoratedComparator may not be null.");
        }
        this.decoratedComparator = decoratedComparator;
        this.nullIsGreaterThan = nullIsGreaterThan;
    }

    public static <T> NullCheckComparatorBuilder<T> builder() {
        return new NullCheckComparatorBuilder();
    }

    public static <T> Comparator<T> of(Comparator<T> decoratedComparator) {
        return NullCheckComparator.builder().decoratedComparator(decoratedComparator).build();
    }

    public static <T> NullCheckComparator<T> of(Comparator<T> decoratedComparator, boolean nullIsGreaterThan) {
        return NullCheckComparator.builder().decoratedComparator(decoratedComparator).nullIsGreaterThan(nullIsGreaterThan).build();
    }

    @Override
    public int compare(T object, T compareWithObject) {
        Integer nullCheck = ComparatorExtensions.nullCheck(object, compareWithObject, this.nullIsGreaterThan);
        if (nullCheck != null) {
            return nullCheck;
        }
        return this.decoratedComparator.compare(object, compareWithObject);
    }

    public static class NullCheckComparatorBuilder<T> {
        private Comparator<T> decoratedComparator;
        private boolean nullIsGreaterThan;

        NullCheckComparatorBuilder() {
        }

        public NullCheckComparator<T> build() {
            return new NullCheckComparator<T>(this.decoratedComparator, this.nullIsGreaterThan);
        }

        public NullCheckComparatorBuilder<T> decoratedComparator(Comparator<T> decoratedComparator) {
            this.decoratedComparator = decoratedComparator;
            return this;
        }

        public NullCheckComparatorBuilder<T> nullIsGreaterThan(boolean nullIsGreaterThan) {
            this.nullIsGreaterThan = nullIsGreaterThan;
            return this;
        }

        public String toString() {
            return "NullCheckComparator.NullCheckComparatorBuilder(decoratedComparator=" + this.decoratedComparator + ", nullIsGreaterThan=" + this.nullIsGreaterThan + ")";
        }
    }
}

