/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.comparator.factory;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;

public class ComparatorFactory {
    private ComparatorFactory() {
    }

    public static <T, U extends Comparable<? super U>> Comparator<T> newBeanPropertyComparator(Function<? super T, ? extends U> beanPropertyFunction) {
        return ComparatorFactory.newBeanPropertyComparator(beanPropertyFunction, false, false);
    }

    public static <T, U extends Comparable<? super U>> Comparator<T> newBeanPropertyComparator(Function<? super T, ? extends U> beanPropertyFunction, boolean nullsFirst, boolean ascending) {
        Comparator order = ascending ? Comparator.reverseOrder() : Comparator.naturalOrder();
        return Comparator.comparing(beanPropertyFunction, nullsFirst ? Comparator.nullsFirst(order) : Comparator.nullsLast(order));
    }

    public static <T> Comparator<T> newDefinedOrderComparator(List<T> definedOrder) {
        Objects.requireNonNull(definedOrder);
        return Comparator.comparing(definedOrder::indexOf);
    }

    public static <T> Comparator<T> newRandomComparator(List<T> list) {
        Objects.requireNonNull(list);
        return ComparatorFactory.newRandomComparator(list, new SecureRandom());
    }

    public static <T> Comparator<T> newRandomComparator(List<T> list, SecureRandom secureRandom) {
        Objects.requireNonNull(list);
        Collections.shuffle(list, secureRandom);
        return Comparator.comparing(list::indexOf);
    }

    public static <K, V> Comparator<V> newRandomMapValuesComparator(Map<K, V> map, SecureRandom secureRandom) {
        ArrayList<V> numberCounterValues = new ArrayList<V>(new TreeSet<V>(map.values()));
        Collections.shuffle(numberCounterValues, secureRandom);
        return ComparatorFactory.newDefinedOrderComparator(numberCounterValues);
    }

    public static <K, V> Comparator<V> newMapValuesComparator(Map<K, V> map) {
        ArrayList<V> numberCounterValues = new ArrayList<V>(new TreeSet<V>(map.values()));
        return ComparatorFactory.newDefinedOrderComparator(numberCounterValues);
    }
}

