/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.api.algorithm.key;

import io.github.astrapi69.crypt.api.algorithm.Algorithm;
import java.util.Arrays;

public enum KeyPairGeneratorAlgorithm implements Algorithm
{
    DIFFIE_HELLMAN("DiffieHellman"),
    DH("DH"),
    DSA("DSA"),
    RSA("RSA"),
    RSASSA_PSS("RSASSA-PSS"),
    EC("EC"),
    XDH("XDH"),
    X25519("X25519"),
    X448("X448"),
    UNKNOWN_TYPE("UNKNOWN ALGORITHM TYPE"),
    UNKNOWN("UNKNOWN ALGORITHM NAME");

    public static final String DIFFIE_HELLMAN_ALGORITHM_NAME = "DiffieHellman";
    public static final String DH_ALGORITHM_NAME = "DH";
    public static final String XDH_ALGORITHM_NAME = "XDH";
    public static final String X25519_ALGORITHM_NAME = "X25519";
    public static final String X448_ALGORITHM_NAME = "X448";
    public static final String DSA_ALGORITHM_NAME = "DSA";
    public static final String EC_ALGORITHM_NAME = "EC";
    public static final String RSA_ALGORITHM_NAME = "RSA";
    public static final String RSASSA_PSS_ALGORITHM_NAME = "RSASSA-PSS";
    public static final String UNKNOWN_ALGORITHM_TYPE = "UNKNOWN ALGORITHM TYPE";
    private final String algorithm;

    private KeyPairGeneratorAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public static KeyPairGeneratorAlgorithm toKeyPairGeneratorAlgorithm(String algorithm) {
        return Arrays.stream(KeyPairGeneratorAlgorithm.values()).filter(algorithmType -> algorithmType.getAlgorithm().equals(algorithm)).findFirst().orElse(UNKNOWN);
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }
}

