/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.api.compound;

import io.github.astrapi69.crypt.api.algorithm.AesAlgorithm;
import io.github.astrapi69.crypt.api.algorithm.Algorithm;
import io.github.astrapi69.crypt.api.algorithm.HashAlgorithm;
import io.github.astrapi69.crypt.api.algorithm.MdAlgorithm;
import io.github.astrapi69.crypt.api.algorithm.SunJCEAlgorithm;
import io.github.astrapi69.crypt.api.algorithm.UnionWord;
import io.github.astrapi69.crypt.api.algorithm.key.KeyPairGeneratorAlgorithm;
import io.github.astrapi69.crypt.api.mechanism.PBEMechanism;
import io.github.astrapi69.crypt.api.mode.Mode;
import io.github.astrapi69.crypt.api.password.PasswordHashType;

public enum CompoundAlgorithm implements Algorithm
{
    PBE_WITH_MD5_AND_AES(PBEMechanism.PBE.name() + UnionWord.With.name() + MdAlgorithm.MD5.name() + UnionWord.And.name() + AesAlgorithm.AES.name()),
    PBE_WITH_MD5_AND_DES(SunJCEAlgorithm.PBEWithMD5AndDES.name()),
    PBE_WITH_SHA1_AND_128BIT_AES_CBC_BC(PBEMechanism.PBE.name() + UnionWord.With.name().toUpperCase() + HashAlgorithm.SHA1.name() + UnionWord.And.name().toUpperCase() + "128BIT" + AesAlgorithm.AES.name() + "-" + Mode.CBC.name() + "-" + Mode.BC.name()),
    PBE_WITH_SHA1_AND_DES_EDE(PBEMechanism.PBE.name() + UnionWord.With.name() + HashAlgorithm.SHA1.name() + UnionWord.And.name() + SunJCEAlgorithm.DESede.name()),
    PBKDF2_WITH_HMAC_SHA1(PasswordHashType.PBKDF2.name() + UnionWord.With.name() + "Hmac" + HashAlgorithm.SHA1.name()),
    SHA1_WITH_RSA(HashAlgorithm.SHA1.getAlgorithm() + UnionWord.With.name().toLowerCase() + KeyPairGeneratorAlgorithm.RSA.getAlgorithm()),
    SHA256_WITH_RSA(HashAlgorithm.SHA256.getAlgorithm() + UnionWord.With.name().toLowerCase() + KeyPairGeneratorAlgorithm.RSA.getAlgorithm()),
    SHA384_WITH_RSA(HashAlgorithm.SHA384.getAlgorithm() + UnionWord.With.name().toLowerCase() + KeyPairGeneratorAlgorithm.RSA.getAlgorithm()),
    SHA512_WITH_RSA(HashAlgorithm.SHA512.getAlgorithm() + UnionWord.With.name().toLowerCase() + KeyPairGeneratorAlgorithm.RSA.getAlgorithm()),
    UNKNOWN("UNKNOWN ALGORITHM NAME");

    public static final int ITERATIONCOUNT = 19;
    public static final String PRIVATE_KEY = "privatetopsecret";
    public static final byte[] SALT;
    private final String algorithm;

    private CompoundAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    public String toString() {
        return this.getAlgorithm();
    }

    static {
        SALT = new byte[]{-87, -101, -56, 50, 86, 53, -29, 3};
    }
}

