/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.api.key;

import java.util.Arrays;

public enum KeyType {
    CERTIFICATE("Certificate"),
    PRIVATE_KEY("Private key"),
    PRIVATE_KEY_PASSWORD_PROTECTED("Password protected private key"),
    PUBLIC_KEY("Public key"),
    PUBLIC_KEY_PASSWORD_PROTECTED("Password protected public key"),
    UNKNOWN("Unknown key type");

    public static final String KEY_TYPE_CERTIFICATE = "Certificate";
    public static final String KEY_TYPE_PRIVATE_KEY = "Private key";
    public static final String KEY_TYPE_PRIVATE_KEY_PASSWORD_PROTECTED = "Password protected private key";
    public static final String KEY_TYPE_PUBLIC_KEY = "Public key";
    public static final String KEY_TYPE_PUBLIC_KEY_PASSWORD_PROTECTED = "Password protected public key";
    public static final String KEY_TYPE_UNKNOWN = "Unknown key type";
    private final String displayValue;

    private KeyType(String displayValue) {
        this.displayValue = displayValue;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public String toString() {
        return this.displayValue;
    }

    public static KeyType toKeyType(String displayValueAsString) {
        return Arrays.stream(KeyType.values()).filter(keyType -> keyType.getDisplayValue().equalsIgnoreCase(displayValueAsString)).findFirst().orElse(UNKNOWN);
    }
}

