/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.api.key;

import java.util.Arrays;

public enum PemType {
    RSA_PRIVATE_KEY("RSA PRIVATE KEY"),
    PRIVATE_KEY("PRIVATE KEY"),
    RSA_PUBLIC_KEY("RSA PUBLIC KEY"),
    PUBLIC_KEY("PUBLIC KEY"),
    DSA_PRIVATE_KEY("DSA PRIVATE KEY"),
    X509_CRL("X509 CRL"),
    CERTIFICATE("CERTIFICATE"),
    CERTIFICATE_REQUEST("CERTIFICATE REQUEST"),
    NEW_CERTIFICATE_REQUEST("NEW CERTIFICATE REQUEST"),
    PKCS7_KEY("PKCS7"),
    EC_PRIVATE_KEY("EC PRIVATE KEY"),
    PGP_PRIVATE_KEY("PGP PRIVATE KEY BLOCK"),
    PGP_PUBLIC_KEY("PGP PUBLIC KEY BLOCK"),
    UNKNOWN_TYPE("UNKNOWN TYPE"),
    UNKNOWN("UNKNOWN TYPE");

    public static final String UNKNOWN_TYPE_NAME = "UNKNOWN TYPE";
    public static final String PRIVATE_KEY_NAME = "PRIVATE KEY";
    public static final String PUBLIC_KEY_NAME = "PUBLIC KEY";
    public static final String RSA_PRIVATE_KEY_NAME = "RSA PRIVATE KEY";
    public static final String RSA_PUBLIC_KEY_NAME = "RSA PUBLIC KEY";
    public static final String DSA_PRIVATE_KEY_NAME = "DSA PRIVATE KEY";
    public static final String X509_CRL_NAME = "X509 CRL";
    public static final String CERTIFICATE_NAME = "CERTIFICATE";
    public static final String CERTIFICATE_REQUEST_NAME = "CERTIFICATE REQUEST";
    public static final String NEW_CERTIFICATE_REQUEST_NAME = "NEW CERTIFICATE REQUEST";
    public static final String PKCS7_KEY_NAME = "PKCS7";
    public static final String EC_PRIVATE_KEY_NAME = "EC PRIVATE KEY";
    public static final String PGP_PRIVATE_KEY_NAME = "PGP PRIVATE KEY BLOCK";
    public static final String PGP_PUBLIC_KEY_NAME = "PGP PUBLIC KEY BLOCK";
    private final String name;

    private PemType(String name) {
        this.name = name;
    }

    public static PemType toPemType(String name) {
        return Arrays.stream(PemType.values()).filter(pemType -> pemType.getName().equalsIgnoreCase(name)).findFirst().orElse(UNKNOWN);
    }

    public String getName() {
        return this.name;
    }
}

