/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.api.obfuscation.rule;

import java.util.Arrays;

public enum Operation {
    LOWERCASE,
    NEGATE,
    NONE,
    UPPERCASE,
    UNKNOWN;


    public static Character operate(char character, Operation operation) {
        return Operation.operate(character, operation, false);
    }

    public static Operation toOperation(String operationAsString) {
        return Arrays.stream(Operation.values()).filter(operation -> operation.name().equalsIgnoreCase(operationAsString)).findFirst().orElse(UNKNOWN);
    }

    public static Character operate(char character, Operation operation, boolean reverse) {
        if (operation != null) {
            switch (operation) {
                case LOWERCASE: {
                    if (reverse) {
                        return Character.valueOf(Character.toUpperCase(character));
                    }
                    return Character.valueOf(Character.toLowerCase(character));
                }
                case UPPERCASE: {
                    if (reverse) {
                        return Character.valueOf(Character.toLowerCase(character));
                    }
                    return Character.valueOf(Character.toUpperCase(character));
                }
                case NEGATE: {
                    if (reverse) {
                        return Character.valueOf(character);
                    }
                    if (Character.isUpperCase(character)) {
                        return Character.valueOf(Character.toLowerCase(character));
                    }
                    return Character.valueOf(Character.toUpperCase(character));
                }
            }
        }
        return Character.valueOf(character);
    }
}

