/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.api.algorithm;

import io.github.astrapi69.crypt.api.algorithm.Algorithm;
import io.github.astrapi69.crypt.api.algorithm.HashAlgorithm;
import io.github.astrapi69.crypt.api.algorithm.MdAlgorithm;

public enum MessageDigestAlgorithm implements Algorithm
{
    MD2(MdAlgorithm.MD2.getAlgorithm()),
    MD5(MdAlgorithm.MD5.getAlgorithm()),
    SHA_1(HashAlgorithm.SHA_1.getAlgorithm()),
    SHA_256(HashAlgorithm.SHA_256.getAlgorithm()),
    SHA_384(HashAlgorithm.SHA_384.getAlgorithm()),
    SHA_512_224(HashAlgorithm.SHA_512.getAlgorithm() + "/224"),
    SHA_512_256(HashAlgorithm.SHA_512.getAlgorithm() + "/256"),
    SHA3_224("SHA3-224"),
    SHA3_256("SHA3-256"),
    SHA3_384("SHA3-384"),
    SHA3_512("SHA3-512"),
    UNKNOWN("UNKNOWN ALGORITHM NAME");

    public static final String SHA3_224_ALGORITHM_NAME = "SHA3-224";
    public static final String SHA3_256_ALGORITHM_NAME = "SHA3-256";
    public static final String SHA3_384_ALGORITHM_NAME = "SHA3-384";
    public static final String SHA3_512_ALGORITHM_NAME = "SHA3-512";
    private final String algorithm;

    private MessageDigestAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }
}

