/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.algorithm;

import java.security.Provider;
import java.security.Security;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;

public class AlgorithmExtensions {
    public static boolean isValid(@NonNull String serviceName, @NonNull String algorithm) {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is marked non-null but is null");
        }
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        Set<String> algorithms = AlgorithmExtensions.getAlgorithms(serviceName);
        return algorithms.contains(algorithm);
    }

    public static Set<String> getAlgorithms(@NonNull String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is marked non-null but is null");
        }
        return Security.getAlgorithms(serviceName);
    }

    public static Set<String> getServiceNames(@NonNull Provider provider) {
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        HashSet<String> serviceNames = new HashSet<String>();
        for (Provider.Service service : provider.getServices()) {
            serviceNames.add(service.getType());
        }
        return serviceNames;
    }

    public static Set<String> getAllServiceNames(Provider[] providers) {
        HashSet<String> serviceNames = new HashSet<String>();
        for (Provider provider : providers) {
            serviceNames.addAll(AlgorithmExtensions.getServiceNames(provider));
        }
        return serviceNames;
    }
}

