/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.blockchain;

import io.github.astrapi69.crypt.api.algorithm.HashAlgorithm;
import io.github.astrapi69.crypt.api.blockchain.IAddress;
import io.github.astrapi69.crypt.data.hash.HashExtensions;
import java.util.Arrays;

public class Address
implements IAddress {
    private byte[] hash;
    private String name;
    private byte[] publicKey;

    public Address() {
    }

    public Address(String name, byte[] publicKey) {
        this.name = name;
        this.publicKey = publicKey;
        this.hash = HashExtensions.hash(name.getBytes(), publicKey, HashAlgorithm.SHA256);
    }

    protected boolean canEqual(Object other) {
        return other instanceof Address;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address other = (Address)o;
        if (!Arrays.equals(this.getHash(), other.getHash())) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        return Arrays.equals(this.getPublicKey(), other.getPublicKey());
    }

    public byte[] getHash() {
        return this.hash;
    }

    public void setHash(byte[] hash) {
        this.hash = hash;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getHash());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPublicKey());
        return result;
    }
}

