/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.blockchain;

import io.github.astrapi69.crypt.api.algorithm.HashAlgorithm;
import io.github.astrapi69.crypt.api.blockchain.ITransaction;
import io.github.astrapi69.crypt.data.hash.HashExtensions;
import java.util.Arrays;

public class Transaction
implements ITransaction {
    private byte[] hash;
    private byte[] senderHash;
    private byte[] signature;
    private String text;
    private long timestamp;

    public Transaction() {
    }

    public Transaction(String text, byte[] senderHash, byte[] signature) {
        this.text = text;
        this.senderHash = senderHash;
        this.signature = signature;
        this.timestamp = System.currentTimeMillis();
        this.hash = HashExtensions.hash(text.getBytes(), senderHash, signature, this.timestamp, HashAlgorithm.SHA256);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)o;
        if (!Arrays.equals(this.getHash(), other.getHash())) {
            return false;
        }
        if (!Arrays.equals(this.getSenderHash(), other.getSenderHash())) {
            return false;
        }
        if (!Arrays.equals(this.getSignature(), other.getSignature())) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        return this.getTimestamp() == other.getTimestamp();
    }

    public byte[] getHash() {
        return this.hash;
    }

    public void setHash(byte[] hash) {
        this.hash = hash;
    }

    public byte[] getSenderHash() {
        return this.senderHash;
    }

    public void setSenderHash(byte[] senderHash) {
        this.senderHash = senderHash;
    }

    public byte[] getSignableData() {
        return this.text.getBytes();
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getHash());
        result = result * 59 + Arrays.hashCode(this.getSenderHash());
        result = result * 59 + Arrays.hashCode(this.getSignature());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        return result;
    }
}

