/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.factory;

import io.github.astrapi69.crypt.api.provider.SecurityProvider;
import io.github.astrapi69.crypt.data.factory.CertificateBuilderFactory;
import io.github.astrapi69.crypt.data.key.KeyInfoExtensions;
import io.github.astrapi69.crypt.data.model.CertificateV1Info;
import io.github.astrapi69.crypt.data.model.CertificateV3Info;
import io.github.astrapi69.crypt.data.model.DistinguishedNameInfo;
import io.github.astrapi69.crypt.data.model.ExtensionInfo;
import io.github.astrapi69.crypt.data.model.Validity;
import io.github.astrapi69.crypt.data.model.X509CertificateV1Info;
import io.github.astrapi69.crypt.data.model.X509CertificateV3Info;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v1CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public final class CertFactory {
    private CertFactory() {
    }

    public static X509Certificate newEndEntityX509CertificateV3(KeyPair keyPair, X500Name issuer, BigInteger serial, Date notBefore, Date notAfter, X500Name subject, String signatureAlgorithm, X509Certificate caCert) throws NoSuchAlgorithmException, OperatorCreationException, CertificateException, IOException {
        return CertFactory.newX509CertificateV3(keyPair, issuer, serial, notBefore, notAfter, subject, signatureAlgorithm, caCert, false);
    }

    public static X509Certificate newIntermediateX509CertificateV3(KeyPair keyPair, X500Name issuer, BigInteger serial, Date notBefore, Date notAfter, X500Name subject, String signatureAlgorithm, X509Certificate caCert) throws NoSuchAlgorithmException, OperatorCreationException, CertificateException, IOException {
        return CertFactory.newX509CertificateV3(keyPair, issuer, serial, notBefore, notAfter, subject, signatureAlgorithm, caCert, true);
    }

    private static X509Certificate newX509CertificateV3(KeyPair keyPair, X500Name issuer, BigInteger serial, Date notBefore, Date notAfter, X500Name subject, String signatureAlgorithm, X509Certificate caCert, boolean isIntermediate) throws NoSuchAlgorithmException, OperatorCreationException, CertificateException, IOException {
        JcaX509ExtensionUtils extensionUtils = new JcaX509ExtensionUtils();
        Extension authorityKeyIdentifier = new Extension(Extension.authorityKeyIdentifier, false, extensionUtils.createAuthorityKeyIdentifier(caCert).toASN1Primitive().getEncoded());
        Extension subjectKeyIdentifier = new Extension(Extension.subjectKeyIdentifier, false, extensionUtils.createSubjectKeyIdentifier(keyPair.getPublic()).toASN1Primitive().getEncoded());
        byte[] encoded = isIntermediate ? new BasicConstraints(0).toASN1Primitive().getEncoded() : new BasicConstraints(false).toASN1Primitive().getEncoded();
        Extension basicConstraints = new Extension(Extension.basicConstraints, false, encoded);
        Extension keyUsage = new Extension(Extension.keyUsage, false, new KeyUsage(160).toASN1Primitive().getEncoded());
        return CertFactory.newX509CertificateV3(keyPair, issuer, serial, notBefore, notAfter, subject, signatureAlgorithm, authorityKeyIdentifier, subjectKeyIdentifier, basicConstraints, keyUsage);
    }

    public static X509Certificate newX509Certificate(PublicKey publicKey, PrivateKey privateKey, BigInteger serialNumber, String subject, String issuer, String signatureAlgorithm, Date start, Date end) throws CertificateException, IllegalStateException, OperatorCreationException {
        X509v3CertificateBuilder certBuilder = CertificateBuilderFactory.newX509v3CertificateBuilder(new X500Name(issuer), serialNumber, start, end, new X500Name(subject), publicKey);
        ContentSigner signer = new JcaContentSignerBuilder(signatureAlgorithm).setProvider(SecurityProvider.BC.name()).build(privateKey);
        return new JcaX509CertificateConverter().setProvider(SecurityProvider.BC.name()).getCertificate(certBuilder.build(signer));
    }

    public static X509Certificate newX509Certificate(String type, byte[] certificateData) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance(type);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(certificateData);
        return (X509Certificate)cf.generateCertificate(inputStream);
    }

    public static X509Certificate newX509CertificateV1(KeyPair keyPair, X500Name issuer, BigInteger serial, Date notBefore, Date notAfter, X500Name subject, String signatureAlgorithm) throws OperatorCreationException, CertificateException {
        JcaX509v1CertificateBuilder certBuilder = new JcaX509v1CertificateBuilder(issuer, serial, notBefore, notAfter, subject, keyPair.getPublic());
        ContentSigner signer = new JcaContentSignerBuilder(signatureAlgorithm).setProvider(SecurityProvider.BC.name()).build(keyPair.getPrivate());
        return new JcaX509CertificateConverter().setProvider(SecurityProvider.BC.name()).getCertificate(certBuilder.build(signer));
    }

    public static X509Certificate newX509CertificateV3(KeyPair keyPair, X500Name issuer, BigInteger serial, Date notBefore, Date notAfter, X500Name subject, String signatureAlgorithm, Extension ... extensions) throws OperatorCreationException, CertificateException {
        X509v3CertificateBuilder certBuilder = CertificateBuilderFactory.newX509v3CertificateBuilder(issuer, serial, notBefore, notAfter, subject, keyPair.getPublic());
        if (extensions != null && 0 < extensions.length) {
            Arrays.stream(extensions).forEach(RuntimeExceptionDecorator.decorate(arg_0 -> ((X509v3CertificateBuilder)certBuilder).addExtension(arg_0)));
        }
        ContentSigner signer = new JcaContentSignerBuilder(signatureAlgorithm).setProvider(SecurityProvider.BC.name()).build(keyPair.getPrivate());
        return new JcaX509CertificateConverter().setProvider(SecurityProvider.BC.name()).getCertificate(certBuilder.build(signer));
    }

    public static X509Certificate newX509CertificateV3(KeyPair keyPair, X500Name issuer, int daysToBeValid, X500Name subject, String signatureAlgorithm, Extension ... extensions) throws OperatorCreationException, CertificateException {
        long now = System.currentTimeMillis();
        Date startDate = new Date(now);
        Date endDate = new Date(now + (long)daysToBeValid * 86400000L);
        BigInteger certSerialNumber = new BigInteger(Long.toString(now));
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithm).build(keyPair.getPrivate());
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(issuer, certSerialNumber, startDate, endDate, subject, keyPair.getPublic());
        if (extensions != null && 0 < extensions.length) {
            Arrays.stream(extensions).forEach(RuntimeExceptionDecorator.decorate(arg_0 -> ((JcaX509v3CertificateBuilder)certBuilder).addExtension(arg_0)));
        }
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certBuilder.build(contentSigner));
    }

    public static X509Certificate newX509CertificateV3(KeyPair keyPair, X509CertificateV3Info certificateInfo) throws OperatorCreationException, CertificateException, CertIOException {
        return CertFactory.newX509CertificateV3(keyPair.getPrivate(), keyPair.getPublic(), certificateInfo);
    }

    public static X509Certificate newX509CertificateV3(PrivateKey privateKey, PublicKey publicKey, X509CertificateV3Info certificateInfo) throws OperatorCreationException, CertificateException, CertIOException {
        X509CertificateV1Info v1Info = certificateInfo.getCertificateV1Info();
        DistinguishedNameInfo issuer = v1Info.getIssuer();
        DistinguishedNameInfo subject = v1Info.getSubject();
        BigInteger serial = v1Info.getSerial();
        Validity validity = v1Info.getValidity();
        String signatureAlgorithm = v1Info.getSignatureAlgorithm();
        ExtensionInfo[] extensions = certificateInfo.getExtensions();
        Date startDate = Date.from(validity.getNotBefore().toInstant());
        Date endDate = Date.from(validity.getNotAfter().toInstant());
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithm).build(privateKey);
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(new X500Name(issuer.toRepresentableString()), serial, startDate, endDate, new X500Name(subject.toRepresentableString()), publicKey);
        if (extensions != null && extensions.length > 0) {
            for (ExtensionInfo extensionInfo : extensions) {
                certBuilder.addExtension(ExtensionInfo.toExtension(extensionInfo));
            }
        }
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certBuilder.build(contentSigner));
    }

    public static X509Certificate newX509CertificateV1(KeyPair keyPair, X509CertificateV1Info certificateInfo) throws OperatorCreationException, CertificateException {
        X500Name issuer = new X500Name(certificateInfo.getIssuer().toRepresentableString());
        BigInteger serial = certificateInfo.getSerial();
        Date notBefore = Date.from(certificateInfo.getValidity().getNotBefore().toInstant());
        Date notAfter = Date.from(certificateInfo.getValidity().getNotAfter().toInstant());
        X500Name subject = new X500Name(certificateInfo.getSubject().toRepresentableString());
        String signatureAlgorithm = certificateInfo.getSignatureAlgorithm();
        JcaX509v1CertificateBuilder certBuilder = new JcaX509v1CertificateBuilder(issuer, serial, notBefore, notAfter, subject, keyPair.getPublic());
        ContentSigner signer = new JcaContentSignerBuilder(signatureAlgorithm).setProvider("BC").build(keyPair.getPrivate());
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certBuilder.build(signer));
    }

    public static X509Certificate newX509CertificateV3(CertificateV3Info certificateInfo) throws OperatorCreationException, CertificateException, CertIOException {
        CertificateV1Info v1Info = certificateInfo.getCertificateV1Info();
        X509CertificateV1Info certificateV1Info = v1Info.getCertificateV1Info();
        PrivateKey privateKey = KeyInfoExtensions.toPrivateKey(v1Info.getPrivateKeyInfo());
        PublicKey publicKey = KeyInfoExtensions.toPublicKey(v1Info.getPublicKeyInfo());
        ExtensionInfo[] extensions = certificateInfo.getExtensions();
        Object x509CertificateV3Info = ((X509CertificateV3Info.X509CertificateV3InfoBuilder)((X509CertificateV3Info.X509CertificateV3InfoBuilder)X509CertificateV3Info.builder().certificateV1Info(certificateV1Info)).extensions(extensions)).build();
        return CertFactory.newX509CertificateV3(privateKey, publicKey, x509CertificateV3Info);
    }
}

