/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.factory;

import io.github.astrapi69.crypt.api.algorithm.compound.CompoundAlgorithm;
import io.github.astrapi69.crypt.data.factory.AlgorithmParameterSpecFactory;
import io.github.astrapi69.crypt.data.factory.KeySpecFactory;
import io.github.astrapi69.crypt.data.factory.SecretKeyFactoryExtensions;
import io.github.astrapi69.crypt.data.model.CryptModel;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.text.Normalizer;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public final class CipherFactory {
    private CipherFactory() {
    }

    public static Cipher newCipher(CryptModel<Cipher, String, String> model) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        KeySpec keySpec = KeySpecFactory.newPBEKeySpec(model.getKey(), model.getSalt(), model.getIterationCount());
        SecretKeyFactory factory = SecretKeyFactoryExtensions.newSecretKeyFactory(model.getAlgorithm().getAlgorithm());
        SecretKey key = factory.generateSecret(keySpec);
        AlgorithmParameterSpec paramSpec = AlgorithmParameterSpecFactory.newPBEParameterSpec(model.getSalt(), model.getIterationCount());
        return CipherFactory.newCipher(model.getOperationMode(), key, paramSpec, key.getAlgorithm());
    }

    public static Cipher newCipher(int operationMode, SecretKey key, String algorithm) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        Cipher cipher = CipherFactory.newCipher(algorithm);
        cipher.init(operationMode, key);
        return cipher;
    }

    public static Cipher newCipher(int operationMode, SecretKey key, AlgorithmParameterSpec paramSpec, String algorithm) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = CipherFactory.newCipher(algorithm);
        cipher.init(operationMode, (Key)key, paramSpec);
        return cipher;
    }

    public static Cipher newCipher(String algorithm) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = Cipher.getInstance(algorithm);
        return cipher;
    }

    public static Cipher newCipher(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        Cipher cipher = Cipher.getInstance(algorithm, provider);
        return cipher;
    }

    public static Cipher newCipher(String password, String algorithm, byte[] salt, int iterationCount, int operationMode) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        KeySpec keySpec = KeySpecFactory.newPBEKeySpec(password, salt, iterationCount);
        SecretKeyFactory factory = SecretKeyFactoryExtensions.newSecretKeyFactory(algorithm);
        SecretKey key = factory.generateSecret(keySpec);
        AlgorithmParameterSpec paramSpec = AlgorithmParameterSpecFactory.newPBEParameterSpec(salt, iterationCount);
        return CipherFactory.newCipher(operationMode, key, paramSpec, key.getAlgorithm());
    }

    public static Cipher newPBECipher(char[] password, int operationMode, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException {
        return CipherFactory.newPBECipher(password, operationMode, algorithm, CompoundAlgorithm.SALT, 19);
    }

    public static Cipher newPBECipher(char[] password, int operationMode, String algorithm, byte[] salt, int iterationCount) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException {
        PBEKeySpec keySpec = new PBEKeySpec(password);
        SecretKeyFactory factory = SecretKeyFactory.getInstance(algorithm);
        SecretKey key = factory.generateSecret(keySpec);
        PBEParameterSpec paramSpec = new PBEParameterSpec(salt, iterationCount);
        return CipherFactory.newCipher(operationMode, key, paramSpec, key.getAlgorithm());
    }

    public static Cipher newPBECipher(String privateKey, String algorithm, byte[] salt, int iterationCount, int operationMode) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        String normalizedPassword = Normalizer.normalize(privateKey, Normalizer.Form.NFC);
        Cipher cipher = CipherFactory.newPBECipher(normalizedPassword.toCharArray(), operationMode, algorithm, salt, iterationCount);
        return cipher;
    }
}

