/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.factory;

import io.github.astrapi69.crypt.data.factory.KeySpecFactory;
import io.github.astrapi69.crypt.data.key.SharedSecretExtensions;
import io.github.astrapi69.crypt.data.model.SharedSecretInfo;
import io.github.astrapi69.crypt.data.model.SharedSecretModel;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;

public class KeyAgreementFactory {
    public static SecretKey newSharedSecret(SharedSecretModel sharedSecretModel) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        KeyAgreement keyAgreement = KeyAgreementFactory.newKeyAgreement(sharedSecretModel.getPrivateKey(), sharedSecretModel.getPublicKey(), sharedSecretModel.getKeyAgreementAlgorithm(), sharedSecretModel.getProvider(), true);
        byte[] sharedSecret = keyAgreement.generateSecret();
        return KeyAgreementFactory.toSecretKey(sharedSecret, sharedSecretModel.getKeyAgreementAlgorithm());
    }

    public static SecretKey newSharedSecret(SharedSecretInfo sharedSecretInfo) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException {
        SharedSecretModel sharedSecretModel = SharedSecretExtensions.toModel(sharedSecretInfo);
        return KeyAgreementFactory.newSharedSecret(sharedSecretModel);
    }

    public static SecretKey newSharedSecret(PrivateKey privateKey, PublicKey publicKey, String keyAgreementAlgorithm, String secretKeyAlgorithm, String provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        KeyAgreement keyAgreement = KeyAgreementFactory.newKeyAgreement(privateKey, publicKey, keyAgreementAlgorithm, provider, true);
        byte[] sharedSecret = keyAgreement.generateSecret();
        return KeyAgreementFactory.toSecretKey(sharedSecret, secretKeyAlgorithm);
    }

    public static SecretKey newSharedSecret(PrivateKey privateKey, PublicKey publicKey, String keyAgreementAlgorithm, String secretKeyAlgorithm, String provider, boolean lastPhase) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        KeyAgreement keyAgreement = KeyAgreementFactory.newKeyAgreement(privateKey, publicKey, keyAgreementAlgorithm, provider, lastPhase);
        byte[] sharedSecret = keyAgreement.generateSecret();
        return KeyAgreementFactory.toSecretKey(sharedSecret, secretKeyAlgorithm);
    }

    public static SecretKey toSecretKey(byte[] sharedSecret, String secretKeyAlgorithm) {
        return KeySpecFactory.newSecretKeySpec(sharedSecret, 0, 16, secretKeyAlgorithm);
    }

    public static byte[] newSharedSecret(PrivateKey privateKey, PublicKey publicKey, String keyAgreementAlgorithm, String provider, boolean lastPhase) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        KeyAgreement keyAgreement = KeyAgreementFactory.newKeyAgreement(privateKey, publicKey, keyAgreementAlgorithm, provider, lastPhase);
        return keyAgreement.generateSecret();
    }

    public static byte[] newSharedSecret(PrivateKey privateKey, PublicKey publicKey, String keyAgreementAlgorithm, String provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        return KeyAgreementFactory.newSharedSecret(privateKey, publicKey, keyAgreementAlgorithm, provider, true);
    }

    public static KeyAgreement newKeyAgreement(PrivateKey privateKey, PublicKey publicKey, String keyAgreementAlgorithm, String provider, boolean lastPhase) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        KeyAgreement keyAgreement = provider != null ? KeyAgreement.getInstance(keyAgreementAlgorithm, provider) : KeyAgreement.getInstance(keyAgreementAlgorithm);
        keyAgreement.init(privateKey);
        keyAgreement.doPhase(publicKey, lastPhase);
        return keyAgreement;
    }
}

