/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.factory;

import io.github.astrapi69.crypt.api.algorithm.Algorithm;
import io.github.astrapi69.crypt.api.key.KeySize;
import io.github.astrapi69.crypt.data.factory.KeyPairGeneratorFactory;
import io.github.astrapi69.crypt.data.key.PrivateKeyExtensions;
import io.github.astrapi69.crypt.data.key.reader.PrivateKeyReader;
import io.github.astrapi69.crypt.data.key.reader.PublicKeyReader;
import io.github.astrapi69.crypt.data.model.KeyPairInfo;
import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import lombok.NonNull;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;

public final class KeyPairFactory {
    private KeyPairFactory() {
    }

    public static KeyPair newKeyPair(Algorithm algorithm, int keySize) throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyPairFactory.newKeyPair(algorithm.getAlgorithm(), keySize);
    }

    public static KeyPair newKeyPair(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyPairFactory.newKeyPair(algorithm, (int)KeySize.KEYSIZE_2048.getKeySize());
    }

    public static KeyPair newKeyPair(Algorithm algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyPairFactory.newKeyPair(algorithm.getAlgorithm(), (int)KeySize.KEYSIZE_2048.getKeySize());
    }

    public static KeyPair newKeyPair(Algorithm algorithm, KeySize keySize) throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyPairFactory.newKeyPair(algorithm.getAlgorithm(), (int)keySize.getKeySize());
    }

    public static KeyPair newKeyPair(File publicKeyDerFile, File privateKeyDerFile) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException, IOException {
        PublicKey publicKey = PublicKeyReader.readPublicKey(publicKeyDerFile);
        PrivateKey privateKey = PrivateKeyReader.readPrivateKey(privateKeyDerFile);
        return KeyPairFactory.newKeyPair(publicKey, privateKey);
    }

    public static KeyPair newKeyPair(PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyPair keyPair = new KeyPair(PrivateKeyExtensions.generatePublicKey(privateKey), privateKey);
        return keyPair;
    }

    public static KeyPair newKeyPair(PublicKey publicKey, PrivateKey privateKey) {
        KeyPair keyPair = new KeyPair(publicKey, privateKey);
        return keyPair;
    }

    public static KeyPair newKeyPair(String algorithm, int keySize) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator generator = KeyPairGeneratorFactory.newKeyPairGenerator(algorithm, keySize);
        return generator.generateKeyPair();
    }

    public static KeyPair newKeyPair(ECNamedCurveParameterSpec namedCurveParameterSpec, String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator generator = KeyPairGeneratorFactory.newKeyPairGenerator(namedCurveParameterSpec, algorithm, provider);
        return generator.generateKeyPair();
    }

    public static KeyPair newKeyPair(String eCNamedCurveParameterSpecName, String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator generator = KeyPairGeneratorFactory.newKeyPairGenerator(eCNamedCurveParameterSpecName, algorithm, provider);
        return generator.generateKeyPair();
    }

    public static KeyPair newKeyPair(@NonNull KeyPairInfo keyPairInfo) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        if (keyPairInfo == null) {
            throw new NullPointerException("keyPairInfo is marked non-null but is null");
        }
        if (keyPairInfo.getECNamedCurveParameterSpecName() != null && keyPairInfo.getProvider() != null) {
            KeyPair keyPair = KeyPairFactory.newKeyPair(keyPairInfo.getECNamedCurveParameterSpecName(), keyPairInfo.getAlgorithm(), keyPairInfo.getProvider());
            return keyPair;
        }
        if (keyPairInfo.getECNamedCurveParameterSpecName() != null) {
            KeyPair keyPair = KeyPairFactory.newKeyPair(keyPairInfo.getECNamedCurveParameterSpecName(), keyPairInfo.getAlgorithm(), "BC");
            return keyPair;
        }
        return KeyPairFactory.newKeyPair(keyPairInfo.getAlgorithm(), keyPairInfo.getKeySize());
    }
}

