/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.factory;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;

public final class KeyPairGeneratorFactory {
    private KeyPairGeneratorFactory() {
    }

    public static KeyPairGenerator newKeyPairGenerator(String algorithm) throws NoSuchAlgorithmException {
        return KeyPairGenerator.getInstance(algorithm);
    }

    public static KeyPairGenerator newKeyPairGenerator(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyPairGenerator.getInstance(algorithm, provider);
    }

    public static KeyPairGenerator newKeyPairGenerator(String algorithm, int keySize) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator generator;
        if ("EC".equals(algorithm)) {
            generator = KeyPairGeneratorFactory.newKeyPairGenerator(algorithm, "BC");
        } else {
            generator = KeyPairGeneratorFactory.newKeyPairGenerator(algorithm);
            generator.initialize(keySize);
        }
        return generator;
    }

    public static KeyPairGenerator newKeyPairGenerator(String algorithm, int keySize, SecureRandom secureRandom) throws NoSuchAlgorithmException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance(algorithm);
        generator.initialize(keySize, secureRandom);
        return generator;
    }

    public static KeyPairGenerator newKeyPairGenerator(String eCNamedCurveParameterSpecName, String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        return KeyPairGeneratorFactory.newKeyPairGenerator(ECNamedCurveTable.getParameterSpec((String)eCNamedCurveParameterSpecName), algorithm, provider);
    }

    public static KeyPairGenerator newKeyPairGenerator(ECNamedCurveParameterSpec namedCurveParameterSpec, String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance(algorithm, provider);
        generator.initialize((AlgorithmParameterSpec)namedCurveParameterSpec);
        return generator;
    }
}

