/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.factory;

import io.github.astrapi69.crypt.data.factory.SecretKeyFactoryExtensions;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class KeySpecFactory {
    private KeySpecFactory() {
    }

    public static KeySpec newPBEKeySpec(String privateKey) {
        if (privateKey == null) {
            return new PBEKeySpec("privatetopsecret".toCharArray());
        }
        return new PBEKeySpec(privateKey.toCharArray());
    }

    public static KeySpec newPBEKeySpec(String password, byte[] salt, int iterationCount) {
        if (password == null) {
            return new PBEKeySpec("privatetopsecret".toCharArray(), salt, iterationCount);
        }
        return new PBEKeySpec(password.toCharArray(), salt, iterationCount);
    }

    public static SecretKeySpec newSecretKeySpec(byte[] secretKey, String algorithm) {
        SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey, algorithm);
        return secretKeySpec;
    }

    public static SecretKeySpec newSecretKeySpec(byte[] secretKey, int offset, int len, String algorithm) {
        SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey, offset, len, algorithm);
        return secretKeySpec;
    }

    public static DESKeySpec newDESKeySpec(byte[] secretKey) throws InvalidKeyException {
        return new DESKeySpec(secretKey);
    }

    public static DESedeKeySpec newDESedeKeySpec(byte[] secretKey) throws InvalidKeyException {
        return new DESedeKeySpec(secretKey);
    }

    public static SecretKeySpec newSecretKeySpec(String algorithm, int keyLength) throws NoSuchAlgorithmException {
        SecretKey secretKey = SecretKeyFactoryExtensions.newSecretKey(algorithm, keyLength);
        byte[] secretKeyEncoded = secretKey.getEncoded();
        return KeySpecFactory.newSecretKeySpec(secretKeyEncoded, algorithm);
    }

    public static SecretKey newSecretKey(byte[] decryptedKey, String algorithm) {
        return new SecretKeySpec(decryptedKey, 0, decryptedKey.length, algorithm);
    }
}

