/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.factory;

import io.github.astrapi69.crypt.data.key.KeyInfoExtensions;
import io.github.astrapi69.crypt.data.key.KeyStoreExtensions;
import io.github.astrapi69.crypt.data.model.KeyInfo;
import io.github.astrapi69.crypt.data.model.KeyStoreInfo;
import io.github.astrapi69.file.create.FileInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public final class KeyStoreFactory {
    private KeyStoreFactory() {
    }

    public static KeyStore loadKeyStore(File keystoreFile, String type, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return KeyStoreFactory.loadKeyStore(keystoreFile, type, password.toCharArray());
    }

    public static KeyStore loadKeyStore(KeyStoreInfo keyStoreInfo) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return KeyStoreFactory.loadKeyStore(FileInfo.toFile((FileInfo)keyStoreInfo.getFileInfo()), keyStoreInfo.getType(), keyStoreInfo.getKeystorePassword());
    }

    public static KeyStore loadKeyStore(File keystoreFile, String type, char[] password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore = KeyStore.getInstance(type);
        keyStore.load(new FileInputStream(keystoreFile), password);
        return keyStore;
    }

    public static KeyStore newKeyStore(File keystoreFile, String type, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return KeyStoreFactory.newKeyStore(keystoreFile, type, password.toCharArray());
    }

    public static KeyStore newKeyStore(File keystoreFile, String type, char[] password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore = KeyStore.getInstance(type);
        keyStore.load(null, password);
        FileOutputStream out = new FileOutputStream(keystoreFile);
        keyStore.store(out, password);
        return keyStore;
    }

    public static KeyStore newKeyStore(KeyStoreInfo keyStoreInfo) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return KeyStoreFactory.newKeyStore(FileInfo.toFile((FileInfo)keyStoreInfo.getFileInfo()), keyStoreInfo.getType(), keyStoreInfo.getKeystorePassword());
    }

    public static KeyStore newKeystoreAndSaveForSsl(KeyStoreInfo keyStoreInfo, KeyInfo privateKeyModel, KeyInfo certificateModel, String certificateAlias, char[] keyPassword) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        PrivateKey privateKey = KeyInfoExtensions.toPrivateKey(privateKeyModel);
        X509Certificate certificate = KeyInfoExtensions.toX509Certificate(certificateModel);
        return KeyStoreFactory.newKeystoreAndSaveForSsl(keyStoreInfo, privateKey, certificate, certificateAlias, keyPassword);
    }

    public static KeyStore newKeystoreAndSaveForSsl(KeyStoreInfo keyStoreInfo, PrivateKey privateKey, Certificate certificate, String certificateAlias, char[] keyPassword) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = KeyStoreInfo.toKeyStore(keyStoreInfo);
        keyStore.setKeyEntry(certificateAlias, privateKey, keyPassword, new Certificate[]{certificate});
        File keystoreFile = FileInfo.toFile((FileInfo)keyStoreInfo.getFileInfo());
        KeyStoreExtensions.store(keyStore, keystoreFile, keyPassword);
        return keyStore;
    }
}

