/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.factory;

import io.github.astrapi69.collection.list.ListFactory;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import lombok.NonNull;

public final class PinFactory {
    private PinFactory() {
    }

    public static List<String> newPins(@NonNull List<LocalDate> localDates, @NonNull List<String> datePatterns) {
        if (localDates == null) {
            throw new NullPointerException("localDates is marked non-null but is null");
        }
        if (datePatterns == null) {
            throw new NullPointerException("datePatterns is marked non-null but is null");
        }
        List result = ListFactory.newArrayList((Object[])new String[0]);
        for (LocalDate localDate : localDates) {
            for (String datePattern : datePatterns) {
                result.add(localDate.format(DateTimeFormatter.ofPattern(datePattern)));
            }
        }
        result.sort(Comparator.naturalOrder());
        return result;
    }
}

