/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.factory;

import io.github.astrapi69.crypt.data.factory.KeySpecFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;

public final class SecretKeyFactoryExtensions {
    private SecretKeyFactoryExtensions() {
    }

    public static SecretKey newSecretKey(char[] password, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(algorithm);
        SecretKey secretKey = secretKeyFactory.generateSecret(pbeKeySpec);
        return secretKey;
    }

    public static SecretKeyFactory newSecretKeyFactory(@NonNull String algorithm) throws NoSuchAlgorithmException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        SecretKeyFactory factory = SecretKeyFactory.getInstance(algorithm);
        return factory;
    }

    public static SecretKeyFactory newSecretKeyFactory(@NonNull String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        SecretKeyFactory factory = provider == null || provider.isEmpty() ? SecretKeyFactoryExtensions.newSecretKeyFactory(algorithm) : SecretKeyFactory.getInstance(algorithm, provider);
        return factory;
    }

    public static SecretKey newSecretKey(String algorithm, int keyLength) throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm);
        keyGenerator.init(keyLength);
        return keyGenerator.generateKey();
    }

    public static SecretKey newSecretKey(byte[] sharedSecret, String secretKeyAlgorithm) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(secretKeyAlgorithm);
        SecretKeySpec secretKeySpec = KeySpecFactory.newSecretKeySpec(sharedSecret, secretKeyAlgorithm);
        SecretKey secretKey = secretKeyFactory.generateSecret(secretKeySpec);
        return secretKey;
    }
}

