/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.hash;

import com.google.common.primitives.Longs;
import io.github.astrapi69.crypt.api.algorithm.HashAlgorithm;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.Queue;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;

public final class HashExtensions {
    private HashExtensions() {
    }

    public static byte[] getMerkleRootHash(Queue<byte[]> hashQueue, HashAlgorithm algorithm) {
        Objects.requireNonNull(algorithm);
        block6: while (hashQueue.size() > 1) {
            byte[] hashValue = ArrayUtils.addAll((byte[])hashQueue.poll(), (byte[])hashQueue.poll());
            switch (algorithm) {
                case SHA1: 
                case SHA_1: {
                    hashQueue.add(DigestUtils.sha1((byte[])hashValue));
                    continue block6;
                }
                case SHA256: 
                case SHA_256: {
                    hashQueue.add(DigestUtils.sha256((byte[])hashValue));
                    continue block6;
                }
                case SHA384: 
                case SHA_384: {
                    hashQueue.add(DigestUtils.sha384((byte[])hashValue));
                    continue block6;
                }
                case SHA512: 
                case SHA_512: {
                    hashQueue.add(DigestUtils.sha512((byte[])hashValue));
                    continue block6;
                }
            }
            hashQueue.add(DigestUtils.sha256((byte[])hashValue));
        }
        return hashQueue.poll();
    }

    public static byte[] hash(byte[] input, byte[] hash, byte[] signature, long timestamp, HashAlgorithm algorithm) {
        Objects.requireNonNull(algorithm);
        byte[] hashValue = ArrayUtils.addAll((byte[])input, (byte[])hash);
        hashValue = ArrayUtils.addAll((byte[])hashValue, (byte[])signature);
        hashValue = ArrayUtils.addAll((byte[])hashValue, (byte[])Longs.toByteArray((long)timestamp));
        switch (algorithm) {
            case SHA1: 
            case SHA_1: {
                return DigestUtils.sha1((byte[])hashValue);
            }
            case SHA256: 
            case SHA_256: {
                return DigestUtils.sha256((byte[])hashValue);
            }
            case SHA384: 
            case SHA_384: {
                return DigestUtils.sha384((byte[])hashValue);
            }
            case SHA512: 
            case SHA_512: {
                return DigestUtils.sha512((byte[])hashValue);
            }
        }
        return DigestUtils.sha256((byte[])hashValue);
    }

    public static byte[] hash(byte[] input, byte[] publicKey, HashAlgorithm algorithm) {
        Objects.requireNonNull(algorithm);
        byte[] hashValue = ArrayUtils.addAll((byte[])input, (byte[])publicKey);
        switch (algorithm) {
            case SHA1: 
            case SHA_1: {
                return DigestUtils.sha1((byte[])hashValue);
            }
            case SHA256: 
            case SHA_256: {
                return DigestUtils.sha256((byte[])hashValue);
            }
            case SHA384: 
            case SHA_384: {
                return DigestUtils.sha384((byte[])hashValue);
            }
            case SHA512: 
            case SHA_512: {
                return DigestUtils.sha512((byte[])hashValue);
            }
        }
        return DigestUtils.sha256((byte[])hashValue);
    }

    public static byte[] hash(byte[] input, byte[] hash, long signature, long timestamp, HashAlgorithm algorithm) {
        Objects.requireNonNull(algorithm);
        byte[] hashValue = ArrayUtils.addAll((byte[])input, (byte[])hash);
        hashValue = ArrayUtils.addAll((byte[])hashValue, (byte[])Longs.toByteArray((long)signature));
        hashValue = ArrayUtils.addAll((byte[])hashValue, (byte[])Longs.toByteArray((long)timestamp));
        switch (algorithm) {
            case SHA1: 
            case SHA_1: {
                return DigestUtils.sha1((byte[])hashValue);
            }
            case SHA256: 
            case SHA_256: {
                return DigestUtils.sha256((byte[])hashValue);
            }
            case SHA384: 
            case SHA_384: {
                return DigestUtils.sha384((byte[])hashValue);
            }
            case SHA512: 
            case SHA_512: {
                return DigestUtils.sha512((byte[])hashValue);
            }
        }
        return DigestUtils.sha256((byte[])hashValue);
    }

    public static byte[] hash(byte[] hashIt, HashAlgorithm hashAlgorithm) throws NoSuchAlgorithmException {
        return HashExtensions.hash(hashIt, null, hashAlgorithm, null);
    }

    public static byte[] hash(byte[] hashIt, String salt, HashAlgorithm hashAlgorithm, Charset charset) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(hashAlgorithm.getAlgorithm());
        messageDigest.reset();
        if (salt != null) {
            messageDigest.update(salt.getBytes(charset));
        }
        messageDigest.update(hashIt);
        byte[] digestBytes = messageDigest.digest();
        return digestBytes;
    }

    public static String hash(String hashIt, String salt, HashAlgorithm hashAlgorithm, Charset charset) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(hashAlgorithm.getAlgorithm());
        messageDigest.reset();
        messageDigest.update(salt.getBytes(charset));
        return new String(messageDigest.digest(hashIt.getBytes(charset)), charset);
    }

    public static String hashAndBase64(String hashIt, String salt, HashAlgorithm hashAlgorithm, Charset charset) throws NoSuchAlgorithmException {
        String hashedAndBase64 = new Base64().encodeToString(HashExtensions.hash(hashIt, salt, hashAlgorithm, charset).getBytes(charset));
        return hashedAndBase64;
    }
}

