/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.key;

import io.github.astrapi69.crypt.api.algorithm.HashAlgorithm;
import io.github.astrapi69.crypt.data.hex.HexExtensions;
import io.github.astrapi69.crypt.data.key.KeyExtensions;
import io.github.astrapi69.crypt.data.model.DistinguishedNameInfo;
import io.github.astrapi69.crypt.data.model.ExtensionInfo;
import io.github.astrapi69.crypt.data.model.Validity;
import io.github.astrapi69.crypt.data.model.X509CertificateV1Info;
import io.github.astrapi69.crypt.data.model.X509CertificateV3Info;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;

public final class CertificateExtensions {
    private CertificateExtensions() {
    }

    public static String toHex(java.security.cert.Certificate certificate) throws CertificateEncodingException {
        String base64 = KeyExtensions.toBase64(certificate.getEncoded());
        byte[] decoded = KeyExtensions.decodeBase64(base64);
        return Hex.encodeHexString((byte[])decoded);
    }

    public static byte[] getEncoded(java.security.cert.Certificate certificate) throws CertificateEncodingException {
        return certificate.getEncoded();
    }

    public static PublicKey getPublicKey(java.security.cert.Certificate certificate) {
        return certificate.getPublicKey();
    }

    public static String toBase64(java.security.cert.Certificate certificate) throws CertificateEncodingException {
        return KeyExtensions.toBase64(CertificateExtensions.getEncoded(certificate));
    }

    public static String getCountry(X509Certificate certificate) throws CertificateEncodingException {
        return CertificateExtensions.getFirstValueOf(certificate, BCStyle.C);
    }

    public static String getFingerprint(X509Certificate certificate, HashAlgorithm hashAlgorithm) throws CertificateEncodingException, NoSuchAlgorithmException {
        byte[] derEncoded = certificate.getEncoded();
        MessageDigest messageDigest = MessageDigest.getInstance(hashAlgorithm.getAlgorithm());
        messageDigest.update(derEncoded);
        byte[] digest = messageDigest.digest();
        return HexExtensions.toHexString(digest);
    }

    public static String getFirstValueOf(X509Certificate certificate, ASN1ObjectIdentifier style) throws CertificateEncodingException {
        X500Name x500name = new JcaX509CertificateHolder(certificate).getSubject();
        RDN[] rdns = x500name.getRDNs(style);
        if (rdns != null && 0 < rdns.length) {
            RDN rdn = rdns[0];
            return IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue());
        }
        return "";
    }

    public static String getIssuedBy(X509Certificate certificate) {
        X500Principal issuedByPrincipal = certificate.getSubjectX500Principal();
        return issuedByPrincipal.getName();
    }

    public static BigInteger getSerialNumber(X509Certificate certificate) {
        return certificate.getSerialNumber();
    }

    public static String getSubject(X509Certificate certificate) {
        return CertificateExtensions.getIssuedBy(certificate);
    }

    public static String getIssuedTo(X509Certificate certificate) {
        X500Principal issuedToPrincipal = certificate.getIssuerX500Principal();
        return issuedToPrincipal.getName();
    }

    public static String getLocality(X509Certificate certificate) throws CertificateEncodingException {
        return CertificateExtensions.getFirstValueOf(certificate, BCStyle.L);
    }

    public static String getOrganization(X509Certificate certificate) throws CertificateEncodingException {
        return CertificateExtensions.getFirstValueOf(certificate, BCStyle.O);
    }

    public static String getSignatureAlgorithm(X509Certificate certificate) {
        return certificate.getSigAlgName();
    }

    public static Date getValidFrom(X509Certificate certificate) {
        return certificate.getNotBefore();
    }

    public static int getVersion(X509Certificate certificate) {
        return certificate.getVersion();
    }

    public static Date getValidUntil(X509Certificate certificate) {
        return certificate.getNotAfter();
    }

    public static X509CertificateV3Info toX509CertificateV3Info(X509Certificate certificate) {
        Object x509CertificateV1Info = ((X509CertificateV1Info.X509CertificateV1InfoBuilder)((X509CertificateV1Info.X509CertificateV1InfoBuilder)((X509CertificateV1Info.X509CertificateV1InfoBuilder)((X509CertificateV1Info.X509CertificateV1InfoBuilder)((X509CertificateV1Info.X509CertificateV1InfoBuilder)X509CertificateV1Info.builder().issuer(DistinguishedNameInfo.toDistinguishedNameInfo(CertificateExtensions.getIssuedTo(certificate)))).serial(new BigInteger(160, new SecureRandom()))).validity((Validity)((Validity.ValidityBuilder)((Validity.ValidityBuilder)Validity.builder().notBefore(ZonedDateTime.parse("2023-12-01T00:00:00Z"))).notAfter(ZonedDateTime.parse("2025-01-01T00:00:00Z"))).build())).subject(DistinguishedNameInfo.toDistinguishedNameInfo(CertificateExtensions.getSubject(certificate)))).signatureAlgorithm("SHA256withRSA")).build();
        Object x509CertificateV3Info = ((X509CertificateV3Info.X509CertificateV3InfoBuilder)((X509CertificateV3Info.X509CertificateV3InfoBuilder)X509CertificateV3Info.builder().certificateV1Info((X509CertificateV1Info)x509CertificateV1Info)).extensions(ExtensionInfo.extractToExtensionInfoArray(certificate))).build();
        return x509CertificateV3Info;
    }

    public static Extensions getExtensions(java.security.cert.Certificate certificate) throws CertificateEncodingException, IOException {
        X509CertificateHolder bcX509Cert = new X509CertificateHolder(Certificate.getInstance((Object)ASN1Primitive.fromByteArray((byte[])certificate.getEncoded())));
        return bcX509Cert.getExtensions();
    }
}

