/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.key;

import java.security.Key;
import javax.xml.bind.DatatypeConverter;
import lombok.NonNull;
import org.apache.commons.codec.binary.Base64;

public final class KeyExtensions {
    private KeyExtensions() {
    }

    public static String toBase64(byte[] encodedKey) {
        return Base64.encodeBase64String((byte[])encodedKey);
    }

    public static String toBase64Binary(byte[] encodedKey) {
        return DatatypeConverter.printBase64Binary((byte[])encodedKey);
    }

    public static byte[] decodeBase64(String base64) {
        return Base64.decodeBase64((String)base64);
    }

    public static String getAlgorithm(@NonNull Key key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return key.getAlgorithm();
    }

    public static byte[] getEncoded(@NonNull Key key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return key.getEncoded();
    }

    public static String getFormat(@NonNull Key key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return key.getFormat();
    }
}

