/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.key;

import io.github.astrapi69.crypt.api.key.KeyType;
import io.github.astrapi69.crypt.data.key.CertificateExtensions;
import io.github.astrapi69.crypt.data.key.reader.CertificateReader;
import io.github.astrapi69.crypt.data.key.reader.PrivateKeyReader;
import io.github.astrapi69.crypt.data.key.reader.PublicKeyReader;
import io.github.astrapi69.crypt.data.model.KeyInfo;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Objects;

public class KeyInfoExtensions {
    public static PrivateKey toPrivateKey(KeyInfo keyInfo) {
        Objects.requireNonNull(keyInfo);
        KeyType keyType = KeyType.toKeyType((String)keyInfo.getKeyType());
        if (!keyType.equals((Object)KeyType.PRIVATE_KEY)) {
            throw new RuntimeException("Given KeyInfo:" + keyInfo.toString() + "\n is not a private key");
        }
        return (PrivateKey)RuntimeExceptionDecorator.decorate(() -> PrivateKeyReader.readPrivateKey(keyInfo.getEncoded(), keyInfo.getAlgorithm()));
    }

    public static PublicKey toPublicKey(KeyInfo keyInfo) {
        Objects.requireNonNull(keyInfo);
        KeyType keyType = KeyType.toKeyType((String)keyInfo.getKeyType());
        if (!keyType.equals((Object)KeyType.PUBLIC_KEY)) {
            throw new RuntimeException("Given KeyInfo:" + keyInfo.toString() + "\n is not a public key");
        }
        return (PublicKey)RuntimeExceptionDecorator.decorate(() -> PublicKeyReader.readPublicKey(keyInfo.getEncoded(), keyInfo.getAlgorithm()));
    }

    public static X509Certificate toX509Certificate(KeyInfo keyInfo) {
        Objects.requireNonNull(keyInfo);
        if (!KeyType.toKeyType((String)keyInfo.getKeyType()).equals((Object)KeyType.CERTIFICATE)) {
            throw new RuntimeException("Given KeyInfo:" + keyInfo.toString() + "\n is not a X509Certificate");
        }
        return (X509Certificate)RuntimeExceptionDecorator.decorate(() -> CertificateReader.readCertificate(keyInfo.getEncoded()));
    }

    public static KeyInfo toKeyInfo(PrivateKey privateKey) {
        return ((KeyInfo.KeyInfoBuilder)((KeyInfo.KeyInfoBuilder)((KeyInfo.KeyInfoBuilder)KeyInfo.builder().encoded(privateKey.getEncoded())).keyType(KeyType.PRIVATE_KEY.getDisplayValue())).algorithm(privateKey.getAlgorithm())).build();
    }

    public static KeyInfo toKeyInfo(PublicKey publicKey) {
        return ((KeyInfo.KeyInfoBuilder)((KeyInfo.KeyInfoBuilder)((KeyInfo.KeyInfoBuilder)KeyInfo.builder().encoded(publicKey.getEncoded())).keyType(KeyType.PUBLIC_KEY.getDisplayValue())).algorithm(publicKey.getAlgorithm())).build();
    }

    public static KeyInfo toKeyInfo(X509Certificate certificate) throws CertificateEncodingException {
        byte[] encoded = CertificateExtensions.getEncoded(certificate);
        return ((KeyInfo.KeyInfoBuilder)((KeyInfo.KeyInfoBuilder)((KeyInfo.KeyInfoBuilder)KeyInfo.builder().encoded(encoded)).algorithm(certificate.getSigAlgName())).keyType(KeyType.CERTIFICATE.getDisplayValue())).build();
    }
}

