/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.key;

import io.github.astrapi69.crypt.api.key.KeyType;
import io.github.astrapi69.crypt.data.key.CertificateExtensions;
import io.github.astrapi69.crypt.data.key.reader.CertificateReader;
import io.github.astrapi69.crypt.data.key.reader.PrivateKeyReader;
import io.github.astrapi69.crypt.data.key.reader.PublicKeyReader;
import io.github.astrapi69.crypt.data.model.KeyModel;
import io.github.astrapi69.throwable.RuntimeExceptionDecorator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Objects;

public class KeyModelExtensions {
    public static PrivateKey toPrivateKey(KeyModel keyModel) {
        Objects.requireNonNull(keyModel);
        if (!keyModel.getKeyType().equals((Object)KeyType.PRIVATE_KEY)) {
            throw new RuntimeException("Given KeyModel:" + keyModel.toString() + "\n is not a private key");
        }
        return (PrivateKey)RuntimeExceptionDecorator.decorate(() -> PrivateKeyReader.readPrivateKey(keyModel.getEncoded(), keyModel.getAlgorithm()));
    }

    public static PublicKey toPublicKey(KeyModel keyModel) {
        Objects.requireNonNull(keyModel);
        if (!keyModel.getKeyType().equals((Object)KeyType.PUBLIC_KEY)) {
            throw new RuntimeException("Given KeyModel:" + keyModel.toString() + "\n is not a public key");
        }
        return (PublicKey)RuntimeExceptionDecorator.decorate(() -> PublicKeyReader.readPublicKey(keyModel.getEncoded(), keyModel.getAlgorithm()));
    }

    public static X509Certificate toX509Certificate(KeyModel keyModel) {
        Objects.requireNonNull(keyModel);
        if (!keyModel.getKeyType().equals((Object)KeyType.CERTIFICATE)) {
            throw new RuntimeException("Given KeyModel:" + keyModel.toString() + "\n is not a X509Certificate");
        }
        return (X509Certificate)RuntimeExceptionDecorator.decorate(() -> CertificateReader.readCertificate(keyModel.getEncoded()));
    }

    public static KeyModel toKeyModel(PrivateKey privateKey) {
        return ((KeyModel.KeyModelBuilder)((KeyModel.KeyModelBuilder)((KeyModel.KeyModelBuilder)KeyModel.builder().encoded(privateKey.getEncoded())).keyType(KeyType.PRIVATE_KEY)).algorithm(privateKey.getAlgorithm())).build();
    }

    public static KeyModel toKeyModel(PublicKey publicKey) {
        return ((KeyModel.KeyModelBuilder)((KeyModel.KeyModelBuilder)((KeyModel.KeyModelBuilder)KeyModel.builder().encoded(publicKey.getEncoded())).keyType(KeyType.PUBLIC_KEY)).algorithm(publicKey.getAlgorithm())).build();
    }

    public static KeyModel toKeyModel(X509Certificate certificate) throws CertificateEncodingException {
        return ((KeyModel.KeyModelBuilder)((KeyModel.KeyModelBuilder)((KeyModel.KeyModelBuilder)KeyModel.builder().encoded(CertificateExtensions.getEncoded(certificate))).algorithm(certificate.getSigAlgName())).keyType(KeyType.CERTIFICATE)).build();
    }
}

