/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.key;

import io.github.astrapi69.crypt.data.key.KeySizeInitializer;
import java.lang.reflect.InvocationTargetException;
import java.security.AlgorithmParameterGenerator;
import java.security.InvalidParameterException;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.crypto.KeyGenerator;

public class KeySizeExtensions {
    public static <T> Set<Integer> getSupportedKeySizes(String algorithm, Class<T> generatorClass, KeySizeInitializer<T> initializer, int minSize, int maxSize, int increment) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        LinkedHashSet<Integer> supportedKeySizes = new LinkedHashSet<Integer>();
        Object generator = generatorClass.getDeclaredMethod("getInstance", String.class).invoke(null, algorithm);
        for (int i = minSize; i <= maxSize; i += increment) {
            try {
                initializer.initialize(generator, i);
                supportedKeySizes.add(i);
                continue;
            }
            catch (InvalidParameterException invalidParameterException) {
                // empty catch block
            }
        }
        return supportedKeySizes;
    }

    public static Set<Integer> getSupportedKeySizesForAlgorithmParameterGenerator(String algorithm) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return KeySizeExtensions.getSupportedKeySizes(algorithm, AlgorithmParameterGenerator.class, (generator, keySize) -> generator.init(keySize), 1, 8192, 1);
    }

    public static Set<Integer> getSupportedKeySizesForKeyPairGenerator(String algorithm) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return KeySizeExtensions.getSupportedKeySizes(algorithm, KeyPairGenerator.class, KeyPairGenerator::initialize, 512, 8192, 64);
    }

    public static Set<Integer> getSupportedKeySizesForKeyGenerator(String algorithm) throws NoSuchAlgorithmException {
        LinkedHashSet<Integer> supportedKeySizes = new LinkedHashSet<Integer>();
        KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm);
        for (int i = 1; i <= 8192; ++i) {
            try {
                keyGenerator.init(i);
                keyGenerator.generateKey();
                supportedKeySizes.add(i);
                continue;
            }
            catch (InvalidParameterException invalidParameterException) {
                // empty catch block
            }
        }
        return supportedKeySizes;
    }
}

