/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.key;

import io.github.astrapi69.crypt.api.type.KeystoreType;
import io.github.astrapi69.crypt.data.factory.KeyStoreFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

public final class KeyStoreExtensions {
    private KeyStoreExtensions() {
    }

    public static void addAndStoreCertificate(KeyStore keyStore, File keystoreFile, String password, String alias, Certificate certificate) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStoreExtensions.addCertificate(keyStore, alias, certificate);
        KeyStoreExtensions.store(keyStore, keystoreFile, password);
    }

    public static void addAndStorePrivateKey(KeyStore keyStore, File keystoreFile, String alias, PrivateKey privateKey, char[] password, Certificate[] certificateChain) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStoreExtensions.addPrivateKey(keyStore, alias, privateKey, password, certificateChain);
        KeyStoreExtensions.store(keyStore, keystoreFile, String.valueOf(password));
    }

    public static void addCertificate(KeyStore keyStore, String alias, Certificate certificate) throws KeyStoreException {
        keyStore.setCertificateEntry(alias, certificate);
    }

    public static void addPrivateKey(KeyStore keyStore, String alias, PrivateKey privateKey, char[] password, Certificate[] certificateChain) throws KeyStoreException {
        keyStore.setKeyEntry(alias, privateKey, password, certificateChain);
    }

    public static Certificate getCertificate(KeyStore keyStore, String alias) throws KeyStoreException {
        return keyStore.getCertificate(alias);
    }

    public static PrivateKey getPrivateKey(KeyStore keyStore, String alias, char[] password) throws UnrecoverableEntryException, NoSuchAlgorithmException, KeyStoreException {
        KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, new KeyStore.PasswordProtection(password));
        return entry.getPrivateKey();
    }

    public static void setKeyEntry(KeyStore keyStore, String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        keyStore.setKeyEntry(alias, key, password, chain);
    }

    public static void deleteAlias(File keystoreFile, String alias, String password) throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, KeyStoreException, IOException {
        KeyStore keyStore = KeyStoreFactory.loadKeyStore(keystoreFile, KeystoreType.JKS.name(), password);
        keyStore.deleteEntry(alias);
        KeyStoreExtensions.store(keyStore, keystoreFile, password);
    }

    public static void store(KeyStore keyStore, File keystoreFile, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStoreExtensions.store(keyStore, keystoreFile, password.toCharArray());
    }

    public static void store(KeyStore keyStore, File keystoreFile, char[] password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        try (FileOutputStream fos = new FileOutputStream(keystoreFile);){
            keyStore.store(fos, password);
        }
    }
}

