/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.key;

import io.github.astrapi69.crypt.api.algorithm.key.KeyPairGeneratorAlgorithm;
import io.github.astrapi69.crypt.api.key.KeySize;
import io.github.astrapi69.crypt.api.key.PemType;
import io.github.astrapi69.crypt.data.hex.HexExtensions;
import io.github.astrapi69.crypt.data.key.KeyExtensions;
import io.github.astrapi69.crypt.data.key.reader.PemObjectReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public final class PrivateKeyExtensions {
    @Generated
    private static final Logger log = Logger.getLogger(PrivateKeyExtensions.class.getName());

    private PrivateKeyExtensions() {
    }

    public static String fromPKCS1ToPemFormat(byte[] privateKeyPKCS1Formatted) throws IOException {
        PemObject pemObject = new PemObject(PemType.RSA_PRIVATE_KEY.getName(), privateKeyPKCS1Formatted);
        StringWriter stringWriter = new StringWriter();
        PemWriter pemWriter = new PemWriter((Writer)stringWriter);
        pemWriter.writeObject((PemObjectGenerator)pemObject);
        pemWriter.close();
        return stringWriter.toString();
    }

    public static PublicKey generatePublicKey(PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (privateKey instanceof RSAPrivateKey) {
            RSAPrivateCrtKey privk = (RSAPrivateCrtKey)privateKey;
            RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(privk.getModulus(), privk.getPublicExponent());
            KeyFactory keyFactory = KeyFactory.getInstance(KeyPairGeneratorAlgorithm.RSA.getAlgorithm());
            return keyFactory.generatePublic(publicKeySpec);
        }
        return null;
    }

    public static int getKeyLength(PrivateKey privateKey) {
        int length = -1;
        if (privateKey == null) {
            return length;
        }
        if (privateKey instanceof RSAPrivateKey) {
            length = ((RSAPrivateKey)privateKey).getModulus().bitLength();
        } else if (privateKey instanceof DSAPrivateKey) {
            length = ((DSAPrivateKey)privateKey).getParams().getQ().bitLength();
        } else if (privateKey instanceof ECPrivateKey) {
            length = ((ECPrivateKey)privateKey).getParams().getCurve().getField().getFieldSize();
        }
        return length;
    }

    public static KeySize getKeySize(PrivateKey privateKey) {
        int length = PrivateKeyExtensions.getKeyLength(privateKey);
        if (length == 1024) {
            return KeySize.KEYSIZE_1024;
        }
        if (length == 2048) {
            return KeySize.KEYSIZE_2048;
        }
        if (length == 4096) {
            return KeySize.KEYSIZE_4096;
        }
        if (length == 8192) {
            return KeySize.KEYSIZE_8192;
        }
        return KeySize.UNKNOWN;
    }

    public static String toBase64(PrivateKey privateKey) {
        return KeyExtensions.toBase64(privateKey.getEncoded());
    }

    public static String toBase64Binary(PrivateKey privateKey) {
        return KeyExtensions.toBase64Binary(privateKey.getEncoded());
    }

    public static String toHexString(PrivateKey privateKey) {
        return PrivateKeyExtensions.toHexString(privateKey, true);
    }

    public static String toHexString(PrivateKey privateKey, boolean lowerCase) {
        return HexExtensions.toHexString(privateKey.getEncoded(), lowerCase);
    }

    public static String toPemFormat(PrivateKey privateKey) throws IOException {
        if (privateKey instanceof ECPrivateKey) {
            return PemObjectReader.toPemFormat(new PemObject(PemType.EC_PRIVATE_KEY.getName(), PrivateKeyExtensions.toPKCS1Format(privateKey)));
        }
        if (privateKey instanceof DSAPrivateKey) {
            return PemObjectReader.toPemFormat(new PemObject(PemType.DSA_PRIVATE_KEY.getName(), PrivateKeyExtensions.toPKCS1Format(privateKey)));
        }
        return PemObjectReader.toPemFormat(new PemObject(PemType.RSA_PRIVATE_KEY.getName(), PrivateKeyExtensions.toPKCS1Format(privateKey)));
    }

    public static byte[] toPKCS1Format(PrivateKey privateKey) throws IOException {
        byte[] encoded = privateKey.getEncoded();
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)encoded);
        ASN1Encodable asn1Encodable = privateKeyInfo.parsePrivateKey();
        ASN1Primitive asn1Primitive = asn1Encodable.toASN1Primitive();
        return asn1Primitive.getEncoded();
    }

    public static String getAlgorithm(PrivateKey privateKey) {
        return privateKey.getAlgorithm();
    }

    public static String getFormat(PrivateKey privateKey) {
        return privateKey.getFormat();
    }

    public static byte[] getEncoded(PrivateKey privateKey) {
        return privateKey.getEncoded();
    }

    public static String getAlgorithm(byte[] keyBytes) {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)keyBytes);
            ASN1ObjectIdentifier algorithmOID = privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm();
            return PrivateKeyExtensions.mapOidToAlgorithm(algorithmOID);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Algorithm from given key bytes can not be resolved", e);
            return "Unknown";
        }
    }

    private static String mapOidToAlgorithm(ASN1ObjectIdentifier oid) {
        if (oid.equals((ASN1Primitive)new ASN1ObjectIdentifier("1.2.840.113549.1.1.1"))) {
            return "RSA";
        }
        if (oid.equals((ASN1Primitive)new ASN1ObjectIdentifier("1.2.840.10040.4.1"))) {
            return "DSA";
        }
        if (oid.equals((ASN1Primitive)new ASN1ObjectIdentifier("1.2.840.10045.2.1"))) {
            return "EC";
        }
        if (oid.equals((ASN1Primitive)new ASN1ObjectIdentifier("1.2.840.113549.1.3.1"))) {
            return "DH";
        }
        if (oid.equals((ASN1Primitive)new ASN1ObjectIdentifier("1.2.840.113549.1.1.5"))) {
            return "X.509";
        }
        if (oid.equals((ASN1Primitive)new ASN1ObjectIdentifier("1.3.101.112"))) {
            return "EdDSA";
        }
        return "Unknown";
    }
}

