/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.key;

import io.github.astrapi69.crypt.data.hex.HexExtensions;
import io.github.astrapi69.crypt.data.key.KeyExtensions;
import io.github.astrapi69.crypt.data.key.writer.PublicKeyWriter;
import io.github.astrapi69.string.StringExtensions;
import java.io.File;
import java.io.IOException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import java.util.Objects;

public final class PublicKeyExtensions {
    private PublicKeyExtensions() {
    }

    public static String getAlgorithm(PublicKey publicKey) {
        return publicKey.getAlgorithm();
    }

    public static String getFormat(PublicKey publicKey) {
        return publicKey.getFormat();
    }

    public static byte[] getEncoded(PublicKey publicKey) {
        return publicKey.getEncoded();
    }

    public static int getKeyLength(PublicKey publicKey) {
        int length = -1;
        if (publicKey == null) {
            return length;
        }
        if (publicKey instanceof RSAPublicKey) {
            length = ((RSAPublicKey)publicKey).getModulus().bitLength();
        }
        if (publicKey instanceof DSAPublicKey) {
            length = ((DSAPublicKey)publicKey).getParams().getP().bitLength();
        }
        if (publicKey instanceof ECPublicKey) {
            length = ((ECPublicKey)publicKey).getParams().getCurve().getField().getFieldSize();
        }
        return length;
    }

    public static String toBase64(PublicKey publicKey) {
        return KeyExtensions.toBase64(publicKey.getEncoded());
    }

    public static String toHexString(PublicKey publicKey) {
        return PublicKeyExtensions.toHexString(publicKey, true);
    }

    public static String toHexString(PublicKey publicKey, boolean lowerCase) {
        return HexExtensions.toHexString(publicKey.getEncoded(), lowerCase);
    }

    public static void toPemFile(PublicKey publicKey, File file) throws IOException {
        Objects.requireNonNull(publicKey);
        Objects.requireNonNull(file);
        PublicKeyWriter.writeInPemFormat(publicKey, file);
    }

    public static String toPemFormat(PublicKey publicKey) {
        String publicKeyAsBase64String = PublicKeyExtensions.toBase64(publicKey);
        List parts = StringExtensions.splitByFixedLength((String)publicKeyAsBase64String, (int)64);
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN PUBLIC KEY-----\n");
        for (String part : parts) {
            sb.append(part);
            sb.append(System.lineSeparator());
        }
        sb.append("-----END PUBLIC KEY-----");
        sb.append(System.lineSeparator());
        return sb.toString();
    }
}

