/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.key.reader;

import io.github.astrapi69.crypt.api.type.CertificateFactoryType;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;

public final class CertificateReader {
    public static final String BEGIN_CERTIFICATE_PREFIX = "-----BEGIN CERTIFICATE-----\n";
    public static final String END_CERTIFICATE_SUFFIX = "-----END CERTIFICATE-----";

    private CertificateReader() {
    }

    public static X509Certificate readCertificate(byte[] decoded) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance(CertificateFactoryType.X_509.getType());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(decoded);
        X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
        return certificate;
    }

    public static X509Certificate readCertificate(File file) throws CertificateException, IOException {
        byte[] decoded = Files.readAllBytes(file.toPath());
        return CertificateReader.readCertificate(decoded);
    }

    public static X509Certificate readPemCertificate(File file) throws IOException, CertificateException {
        String privateKeyAsString = CertificateReader.readPemFileAsBase64(file);
        byte[] decoded = new Base64().decode(privateKeyAsString);
        return CertificateReader.readCertificate(decoded);
    }

    public static String readPemFileAsBase64(File file) throws IOException {
        byte[] keyBytes = Files.readAllBytes(file.toPath());
        String publicKeyAsBase64String = new String(keyBytes).replace(BEGIN_CERTIFICATE_PREFIX, "").replace(END_CERTIFICATE_SUFFIX, "");
        return publicKeyAsBase64String;
    }
}

