/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.key.reader;

import io.github.astrapi69.crypt.api.algorithm.key.KeyPairGeneratorAlgorithm;
import io.github.astrapi69.crypt.api.provider.SecurityProvider;
import io.github.astrapi69.crypt.data.factory.CipherFactory;
import io.github.astrapi69.crypt.data.factory.KeySpecFactory;
import io.github.astrapi69.crypt.data.factory.SecretKeyFactoryExtensions;
import io.github.astrapi69.crypt.data.key.reader.PrivateKeyReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import lombok.Generated;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;

public final class EncryptedPrivateKeyReader {
    @Generated
    private static final Logger log = Logger.getLogger(EncryptedPrivateKeyReader.class.getName());

    private EncryptedPrivateKeyReader() {
    }

    public static KeyPair getKeyPair(File encryptedPrivateKeyFile, String password) throws FileNotFoundException, IOException, PEMException, PKCSException {
        KeyPair keyPair;
        PEMParser pemParser = new PEMParser((Reader)new FileReader(encryptedPrivateKeyFile));
        Object pemObject = pemParser.readObject();
        pemParser.close();
        JcaPEMKeyConverter keyConverter = new JcaPEMKeyConverter().setProvider(SecurityProvider.BC.name());
        if (pemObject instanceof PEMEncryptedKeyPair) {
            PEMDecryptorProvider decryptorProvider = new JcePEMDecryptorProviderBuilder().setProvider(SecurityProvider.BC.name()).build(password.toCharArray());
            keyPair = keyConverter.getKeyPair(((PEMEncryptedKeyPair)pemObject).decryptKeyPair(decryptorProvider));
        } else if (pemObject instanceof PEMKeyPair) {
            keyPair = keyConverter.getKeyPair((PEMKeyPair)pemObject);
        } else if (pemObject instanceof PKCS8EncryptedPrivateKeyInfo) {
            PKCS8EncryptedPrivateKeyInfo encryptedInfo = (PKCS8EncryptedPrivateKeyInfo)pemObject;
            PrivateKey privateKey = keyConverter.getPrivateKey(encryptedInfo.decryptPrivateKeyInfo(new JcePKCSPBEInputDecryptorProviderBuilder().setProvider(SecurityProvider.BC.name()).build(password.toCharArray())));
            keyPair = new KeyPair(null, privateKey);
        } else {
            throw new PEMException("Invalid PEM object type: " + pemObject.getClass().getName());
        }
        return keyPair;
    }

    public static PrivateKey readPasswordProtectedPrivateKey(byte[] encryptedPrivateKeyBytes, String password, String algorithm) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException {
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(encryptedPrivateKeyBytes);
        String algName = encryptedPrivateKeyInfo.getAlgName();
        Cipher cipher = CipherFactory.newCipher(algName);
        KeySpec pbeKeySpec = KeySpecFactory.newPBEKeySpec(password);
        SecretKeyFactory secretKeyFactory = SecretKeyFactoryExtensions.newSecretKeyFactory(algName);
        SecretKey pbeKey = secretKeyFactory.generateSecret(pbeKeySpec);
        AlgorithmParameters algParameters = encryptedPrivateKeyInfo.getAlgParameters();
        cipher.init(2, (Key)pbeKey, algParameters);
        PKCS8EncodedKeySpec pkcs8KeySpec = encryptedPrivateKeyInfo.getKeySpec(cipher);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePrivate(pkcs8KeySpec);
    }

    public static PrivateKey readPasswordProtectedPrivateKey(File encryptedPrivateKeyFile, String password) throws OperatorCreationException, PKCSException {
        return EncryptedPrivateKeyReader.getPrivateKey(encryptedPrivateKeyFile, password).orElse(null);
    }

    public static Optional<PrivateKey> getPrivateKey(File encryptedPrivateKeyFile, String password) throws OperatorCreationException, PKCSException {
        Optional<PrivateKey> optionalPrivateKey = Optional.empty();
        try {
            PrivateKey privateKey = EncryptedPrivateKeyReader.readPasswordProtectedPrivateKey(encryptedPrivateKeyFile, password, KeyPairGeneratorAlgorithm.RSA.getAlgorithm());
            optionalPrivateKey = Optional.of(privateKey);
            return optionalPrivateKey;
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException e) {
            log.log(Level.WARNING, "Given password protected private key file is not stored in 'RSA' algorithm");
            try {
                PrivateKey privateKey = EncryptedPrivateKeyReader.readPasswordProtectedPrivateKey(encryptedPrivateKeyFile, password, KeyPairGeneratorAlgorithm.DIFFIE_HELLMAN.getAlgorithm());
                optionalPrivateKey = Optional.of(privateKey);
                return optionalPrivateKey;
            }
            catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException e2) {
                log.log(Level.WARNING, "Given password protected private key file is not stored in 'DiffieHellman' algorithm");
                try {
                    PrivateKey privateKey = EncryptedPrivateKeyReader.readPasswordProtectedPrivateKey(encryptedPrivateKeyFile, password, KeyPairGeneratorAlgorithm.DSA.getAlgorithm());
                    optionalPrivateKey = Optional.of(privateKey);
                    return optionalPrivateKey;
                }
                catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException e3) {
                    log.log(Level.WARNING, "Given password protected private key file is not stored in 'DSA' algorithm");
                    try {
                        PrivateKey privateKey = EncryptedPrivateKeyReader.readPasswordProtectedPrivateKey(encryptedPrivateKeyFile, password, KeyPairGeneratorAlgorithm.EC.getAlgorithm());
                        optionalPrivateKey = Optional.of(privateKey);
                        return optionalPrivateKey;
                    }
                    catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException e4) {
                        log.log(Level.WARNING, "Given password protected private key file is not stored in 'EC' algorithm");
                        return optionalPrivateKey;
                    }
                }
            }
        }
    }

    public static PrivateKey readPasswordProtectedPrivateKey(File encryptedPrivateKeyFile, String password, String algorithm) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException, PKCSException {
        PrivateKey privateKey = null;
        boolean pemFormat = PrivateKeyReader.isPemFormat(encryptedPrivateKeyFile);
        if (pemFormat) {
            KeyPair keyPair = EncryptedPrivateKeyReader.getKeyPair(encryptedPrivateKeyFile, password);
            if (keyPair != null) {
                privateKey = keyPair.getPrivate();
            }
        } else {
            byte[] encryptedPrivateKeyBytes = Files.readAllBytes(encryptedPrivateKeyFile.toPath());
            privateKey = EncryptedPrivateKeyReader.readPasswordProtectedPrivateKey(encryptedPrivateKeyBytes, password, algorithm);
        }
        return privateKey;
    }
}

