/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.key.reader;

import io.github.astrapi69.crypt.api.algorithm.Algorithm;
import io.github.astrapi69.crypt.api.algorithm.key.KeyPairGeneratorAlgorithm;
import io.github.astrapi69.crypt.api.key.PemType;
import io.github.astrapi69.crypt.api.provider.SecurityProvider;
import io.github.astrapi69.crypt.data.key.reader.PrivateKeyReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Optional;
import lombok.NonNull;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;

public final class PemObjectReader {
    private PemObjectReader() {
    }

    public static PemObject getPemObject(@NonNull File file) throws IOException {
        PemObject pemObject;
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (PemReader pemReader = new PemReader((Reader)new InputStreamReader(new FileInputStream(file)));){
            pemObject = pemReader.readPemObject();
        }
        return pemObject;
    }

    public static PemObject getPemObject(@NonNull String pemString) throws IOException {
        PemObject pemObject;
        if (pemString == null) {
            throw new NullPointerException("pemString is marked non-null but is null");
        }
        try (PemReader pemReader = new PemReader((Reader)new InputStreamReader(new ByteArrayInputStream(pemString.getBytes())));){
            pemObject = pemReader.readPemObject();
        }
        return pemObject;
    }

    public static boolean isPemObject(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return PemObjectReader.getPemObject(file) != null;
    }

    public static Object readPemKeyObject(@NonNull File keyFile) throws IOException {
        if (keyFile == null) {
            throw new NullPointerException("keyFile is marked non-null but is null");
        }
        try (PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(new FileInputStream(keyFile)));){
            Object object = pemParser.readObject();
            return object;
        }
    }

    public static Optional<PrivateKey> readPemPrivateKey(@NonNull File keyFile, String password) throws IOException {
        if (keyFile == null) {
            throw new NullPointerException("keyFile is marked non-null but is null");
        }
        Object pemKeyObject = PemObjectReader.readPemKeyObject(keyFile);
        if (pemKeyObject instanceof PEMEncryptedKeyPair) {
            PEMEncryptedKeyPair encryptedKeyPair = (PEMEncryptedKeyPair)pemKeyObject;
            PEMDecryptorProvider pemDecryptorProvider = new JcePEMDecryptorProviderBuilder().build(password.toCharArray());
            PEMKeyPair pemKeyPair = encryptedKeyPair.decryptKeyPair(pemDecryptorProvider);
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(SecurityProvider.BC.name());
            return Optional.of(converter.getPrivateKey(pemKeyPair.getPrivateKeyInfo()));
        }
        return Optional.empty();
    }

    public static PrivateKey readPemPrivateKey(@NonNull File keyPemFile) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        if (keyPemFile == null) {
            throw new NullPointerException("keyPemFile is marked non-null but is null");
        }
        return PemObjectReader.readPrivateKey(keyPemFile, (Algorithm)KeyPairGeneratorAlgorithm.RSA);
    }

    public static PrivateKey readPrivateKey(@NonNull File keyPemFile, @NonNull Algorithm algorithm) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        if (keyPemFile == null) {
            throw new NullPointerException("keyPemFile is marked non-null but is null");
        }
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        return PrivateKeyReader.readPrivateKey(PemObjectReader.getPemObject(keyPemFile).getContent(), algorithm.getAlgorithm());
    }

    public static String toPemFormat(@NonNull PemObject pemObject) throws IOException {
        if (pemObject == null) {
            throw new NullPointerException("pemObject is marked non-null but is null");
        }
        StringWriter stringWriter = new StringWriter();
        PemWriter pemWriter = new PemWriter((Writer)stringWriter);
        pemWriter.writeObject((PemObjectGenerator)pemObject);
        pemWriter.close();
        return stringWriter.toString();
    }

    public static Optional<String> toPemFormat(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        PemObject pemObject = PemObjectReader.getPemObject(file);
        if (pemObject != null) {
            return Optional.of(PemObjectReader.toPemFormat(pemObject));
        }
        return Optional.empty();
    }

    public static byte[] toDer(@NonNull PemObject pemObject) {
        if (pemObject == null) {
            throw new NullPointerException("pemObject is marked non-null but is null");
        }
        return pemObject.getContent();
    }

    public static PemType getPemType(@NonNull PemObject pemObject) {
        if (pemObject == null) {
            throw new NullPointerException("pemObject is marked non-null but is null");
        }
        return PemType.toPemType((String)pemObject.getType());
    }

    public static PemType getPemType(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        PemObject pemObject = PemObjectReader.getPemObject(file);
        if (pemObject == null) {
            throw new RuntimeException("Given file contains no pem formatted key");
        }
        return PemObjectReader.getPemType(pemObject);
    }
}

