/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.key.reader;

import io.github.astrapi69.crypt.api.algorithm.key.KeyPairGeneratorAlgorithm;
import io.github.astrapi69.crypt.api.key.KeyFileFormat;
import io.github.astrapi69.crypt.api.key.KeyStringEntry;
import io.github.astrapi69.crypt.api.key.KeyType;
import io.github.astrapi69.crypt.data.algorithm.CryptoAlgorithm;
import io.github.astrapi69.crypt.data.key.reader.PemObjectReader;
import io.github.astrapi69.crypt.data.model.KeyInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.util.io.pem.PemObject;

public final class PrivateKeyReader {
    @Generated
    private static final Logger log = Logger.getLogger(PrivateKeyReader.class.getName());

    private PrivateKeyReader() {
    }

    public static boolean isPemFormat(File file) throws IOException {
        return PemObjectReader.isPemObject(file);
    }

    public static KeyFileFormat getKeyFormat(File file) throws IOException {
        if (!PrivateKeyReader.validatePrivateKey(file)) {
            return KeyFileFormat.UNKNOWN;
        }
        if (PrivateKeyReader.isPemFormat(file)) {
            return KeyFileFormat.PEM;
        }
        return KeyFileFormat.DER;
    }

    public static boolean isPrivateKeyPasswordProtected(File file) throws IOException {
        boolean passwordProtected = false;
        if (PrivateKeyReader.isPemFormat(file)) {
            try {
                PrivateKeyReader.readPemPrivateKey(file);
            }
            catch (Exception e) {
                passwordProtected = true;
            }
        } else {
            try {
                passwordProtected = PrivateKeyReader.readPrivateKey(file) == null;
            }
            catch (Exception e) {
                passwordProtected = true;
            }
        }
        return passwordProtected;
    }

    public static boolean validatePrivateKey(File file) throws IOException {
        boolean valid = true;
        if (PrivateKeyReader.isPemFormat(file)) {
            try {
                PrivateKeyReader.readPemPrivateKey(file);
            }
            catch (Exception e) {
                valid = false;
            }
        } else {
            try {
                valid = PrivateKeyReader.readPrivateKey(file) != null;
            }
            catch (Exception e) {
                valid = false;
            }
        }
        return valid;
    }

    public static String readPemFileAsBase64(File file) throws IOException {
        byte[] keyBytes = Files.readAllBytes(file.toPath());
        String privateKeyPem = new String(keyBytes);
        String privateKeyAsBase64String = null;
        if (privateKeyPem.contains(KeyStringEntry.BEGIN_PRIVATE_KEY_PREFIX.getValue())) {
            privateKeyAsBase64String = new String(keyBytes).replace(KeyStringEntry.BEGIN_PRIVATE_KEY_PREFIX.getValue(), "").replaceAll(System.lineSeparator(), "").replace(KeyStringEntry.END_PRIVATE_KEY_SUFFIX.getValue(), "").trim();
        }
        if (privateKeyPem.contains(KeyStringEntry.BEGIN_RSA_PRIVATE_KEY_PREFIX.getValue())) {
            privateKeyAsBase64String = new String(keyBytes).replace(KeyStringEntry.BEGIN_RSA_PRIVATE_KEY_PREFIX.getValue(), "").replaceAll(System.lineSeparator(), "").replace(KeyStringEntry.END_RSA_PRIVATE_KEY_SUFFIX.getValue(), "").trim();
        }
        return privateKeyAsBase64String;
    }

    public static PrivateKey readPemPrivateKey(File file) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        return PemObjectReader.readPemPrivateKey(file);
    }

    public static PrivateKey readPemPrivateKey(File file, String algorithm) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        return PemObjectReader.readPrivateKey(file, CryptoAlgorithm.newAlgorithm(algorithm));
    }

    public static PrivateKey readPemPrivateKey(String privateKeyAsString, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        byte[] decoded = new Base64().decode(privateKeyAsString);
        return PrivateKeyReader.readPrivateKey(decoded, algorithm);
    }

    public static PrivateKey readPrivateKey(PemObject pemObject, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        byte[] decoded = pemObject.getContent();
        return PrivateKeyReader.readPrivateKey(decoded, algorithm);
    }

    public static PrivateKey readPemPrivateKey(String privateKeyAsString) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        return PrivateKeyReader.readPemPrivateKey(privateKeyAsString, KeyPairGeneratorAlgorithm.RSA.getAlgorithm());
    }

    public static PrivateKey readPrivateKey(byte[] privateKeyBytes) {
        return PrivateKeyReader.getPrivateKey(privateKeyBytes).orElse(null);
    }

    public static PrivateKey readPrivateKey(byte[] privateKeyBytes, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePrivate(keySpec);
    }

    public static PrivateKey readPrivateKey(KeyInfo keyInfo) throws NoSuchAlgorithmException, InvalidKeySpecException {
        Objects.requireNonNull(keyInfo);
        KeyType keyType = KeyType.toKeyType((String)keyInfo.getKeyType());
        if (!keyType.equals((Object)KeyType.PRIVATE_KEY)) {
            throw new RuntimeException("Given KeyModel:" + keyInfo + "\n is not a private key");
        }
        return PrivateKeyReader.readPrivateKey(keyInfo.getEncoded(), keyInfo.getAlgorithm());
    }

    public static PrivateKey readPrivateKey(File file) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        if (PrivateKeyReader.isPemFormat(file)) {
            return PrivateKeyReader.readPemPrivateKey(file);
        }
        return PrivateKeyReader.getPrivateKey(file).orElse(null);
    }

    public static Optional<PrivateKey> getPrivateKey(File privateKeyFile) throws IOException {
        return PrivateKeyReader.getPrivateKey(Files.readAllBytes(privateKeyFile.toPath()));
    }

    public static Optional<PrivateKey> getPrivateKey(byte[] privateKeyBytes) {
        Optional<PrivateKey> optionalPrivateKey = Optional.empty();
        try {
            PrivateKey privateKey = PrivateKeyReader.readPrivateKey(privateKeyBytes, KeyPairGeneratorAlgorithm.DIFFIE_HELLMAN.getAlgorithm());
            optionalPrivateKey = Optional.of(privateKey);
            return optionalPrivateKey;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            log.log(Level.WARNING, "Given private key file is not stored in 'DiffieHellman' algorithm", e);
            try {
                PrivateKey privateKey = PrivateKeyReader.readPrivateKey(privateKeyBytes, KeyPairGeneratorAlgorithm.DSA.getAlgorithm());
                optionalPrivateKey = Optional.of(privateKey);
                return optionalPrivateKey;
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e2) {
                log.log(Level.WARNING, "Given private key file is not stored in 'DSA' algorithm", e2);
                try {
                    PrivateKey privateKey = PrivateKeyReader.readPrivateKey(privateKeyBytes, KeyPairGeneratorAlgorithm.EC.getAlgorithm());
                    optionalPrivateKey = Optional.of(privateKey);
                    return optionalPrivateKey;
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e3) {
                    log.log(Level.WARNING, "Given private key file is not stored in 'EC' algorithm", e3);
                    try {
                        PrivateKey privateKey = PrivateKeyReader.readPrivateKey(privateKeyBytes, KeyPairGeneratorAlgorithm.RSASSA_PSS.getAlgorithm());
                        optionalPrivateKey = Optional.of(privateKey);
                        return optionalPrivateKey;
                    }
                    catch (NoSuchAlgorithmException | InvalidKeySpecException e4) {
                        log.log(Level.WARNING, "Given private key file is not stored in 'RSASSA-PSS' algorithm", e4);
                        try {
                            PrivateKey privateKey = PrivateKeyReader.readPrivateKey(privateKeyBytes, KeyPairGeneratorAlgorithm.RSA.getAlgorithm());
                            optionalPrivateKey = Optional.of(privateKey);
                            return optionalPrivateKey;
                        }
                        catch (NoSuchAlgorithmException | InvalidKeySpecException e5) {
                            log.log(Level.WARNING, "Given private key file is stored in an 'RSA' algorithm", e5);
                            return optionalPrivateKey;
                        }
                    }
                }
            }
        }
    }

    public static PrivateKey readPrivateKey(File file, String algorithm) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] keyBytes = Files.readAllBytes(file.toPath());
        return PrivateKeyReader.readPrivateKey(keyBytes, algorithm);
    }

    public static PrivateKey readPrivateKey(File root, String directory, String fileName) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException, IOException {
        return PrivateKeyReader.readPrivateKey(new File(new File(root, directory), fileName));
    }
}

