/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.key.reader;

import io.github.astrapi69.crypt.api.algorithm.key.KeyPairGeneratorAlgorithm;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.util.io.pem.PemObject;

public final class PublicKeyReader {
    public static final String BEGIN_PUBLIC_KEY_PREFIX = "-----BEGIN PUBLIC KEY-----\n";
    public static final String END_PUBLIC_KEY_SUFFIX = "-----END PUBLIC KEY-----";

    private PublicKeyReader() {
    }

    public static String readPemFileAsBase64(File file) throws IOException {
        byte[] keyBytes = Files.readAllBytes(file.toPath());
        String publicKeyAsBase64String = new String(keyBytes).replace(BEGIN_PUBLIC_KEY_PREFIX, "").replaceAll(System.lineSeparator(), "").replace(END_PUBLIC_KEY_SUFFIX, "");
        return publicKeyAsBase64String;
    }

    public static PublicKey readPemPublicKey(File file) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        return PublicKeyReader.readPemPublicKey(file, KeyPairGeneratorAlgorithm.RSA.getAlgorithm());
    }

    public static PublicKey readPemPublicKey(File file, String algorithm) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        String publicKeyAsString = PublicKeyReader.readPemFileAsBase64(file);
        byte[] decoded = Base64.decodeBase64((String)publicKeyAsString);
        return PublicKeyReader.readPublicKey(decoded, algorithm);
    }

    public static PublicKey readPublicKey(byte[] publicKeyBytes) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        return PublicKeyReader.readPublicKey(publicKeyBytes, KeyPairGeneratorAlgorithm.RSA.getAlgorithm());
    }

    public static PublicKey readPublicKey(byte[] publicKeyBytes, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }

    public static PublicKey readPublicKey(PemObject pemObject, String algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        return PublicKeyReader.readPublicKey(pemObject.getContent(), algorithm);
    }

    public static PublicKey readPublicKey(File file) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        byte[] keyBytes = Files.readAllBytes(file.toPath());
        return PublicKeyReader.readPublicKey(keyBytes);
    }
}

