/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.key.writer;

import io.github.astrapi69.crypt.api.key.KeyFileFormat;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;

public final class CertificateWriter {
    private CertificateWriter() {
    }

    public static void write(X509Certificate certificate, File file, KeyFileFormat fileFormat) throws IOException, CertificateEncodingException {
        Objects.requireNonNull(file);
        CertificateWriter.write(certificate, new FileOutputStream(file), fileFormat);
    }

    public static void write(X509Certificate certificate, OutputStream outputStream, KeyFileFormat fileFormat) throws IOException, CertificateEncodingException {
        Objects.requireNonNull(outputStream);
        byte[] certificateBytes = certificate.getEncoded();
        switch (fileFormat) {
            case PEM: {
                outputStream.write("-----BEGIN CERTIFICATE-----\n".getBytes(StandardCharsets.US_ASCII));
                outputStream.write(Base64.encodeBase64((byte[])certificateBytes, (boolean)true));
                outputStream.write("-----END CERTIFICATE-----".getBytes(StandardCharsets.US_ASCII));
                break;
            }
            default: {
                outputStream.write(certificateBytes);
            }
        }
        outputStream.close();
    }

    public static void writeInDerFormat(X509Certificate certificate, File file) throws IOException, CertificateEncodingException {
        Objects.requireNonNull(file);
        CertificateWriter.writeInDerFormat(certificate, new FileOutputStream(file));
    }

    public static void writeInDerFormat(X509Certificate certificate, OutputStream outputStream) throws IOException, CertificateEncodingException {
        Objects.requireNonNull(outputStream);
        CertificateWriter.write(certificate, outputStream, KeyFileFormat.DER);
    }

    public static void writeInPemFormat(X509Certificate certificate, File file) throws IOException, CertificateEncodingException {
        Objects.requireNonNull(file);
        CertificateWriter.writeInPemFormat(certificate, new FileOutputStream(file));
    }

    public static void writeInPemFormat(X509Certificate certificate, OutputStream outputStream) throws IOException, CertificateEncodingException {
        Objects.requireNonNull(outputStream);
        CertificateWriter.write(certificate, outputStream, KeyFileFormat.PEM);
    }
}

