/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.key.writer;

import io.github.astrapi69.crypt.api.algorithm.compound.CompoundAlgorithm;
import io.github.astrapi69.crypt.api.algorithm.key.KeyPairGeneratorAlgorithm;
import io.github.astrapi69.crypt.data.factory.AlgorithmParameterSpecFactory;
import io.github.astrapi69.crypt.data.factory.SecretKeyFactoryExtensions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public final class EncryptedPrivateKeyWriter {
    private EncryptedPrivateKeyWriter() {
    }

    public static void encryptPrivateKeyWithPassword(PrivateKey privateKey, File file, String password) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InvalidParameterSpecException, IOException {
        EncryptedPrivateKeyWriter.encryptPrivateKeyWithPassword(privateKey, new FileOutputStream(file), password);
    }

    public static void encryptPrivateKeyWithPassword(PrivateKey privateKey, OutputStream outputStream, String password) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InvalidParameterSpecException, IOException {
        Objects.requireNonNull(outputStream);
        byte[] encryptedPrivateKeyWithPasswordBytes = EncryptedPrivateKeyWriter.encryptPrivateKeyWithPassword(privateKey, password);
        outputStream.write(encryptedPrivateKeyWithPasswordBytes);
        outputStream.close();
    }

    public static byte[] encryptPrivateKeyWithPassword(PrivateKey privateKey, String password) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InvalidParameterSpecException, IOException {
        byte[] privateKeyEncoded = privateKey.getEncoded();
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[8];
        random.nextBytes(salt);
        AlgorithmParameterSpec algorithmParameterSpec = AlgorithmParameterSpecFactory.newPBEParameterSpec(salt, 20);
        SecretKey secretKey = SecretKeyFactoryExtensions.newSecretKey(password.toCharArray(), CompoundAlgorithm.PBE_WITH_SHA1_AND_DES_EDE.getAlgorithm());
        Cipher pbeCipher = Cipher.getInstance(CompoundAlgorithm.PBE_WITH_SHA1_AND_DES_EDE.getAlgorithm());
        pbeCipher.init(1, (Key)secretKey, algorithmParameterSpec);
        byte[] ciphertext = pbeCipher.doFinal(privateKeyEncoded);
        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(CompoundAlgorithm.PBE_WITH_SHA1_AND_DES_EDE.getAlgorithm());
        algorithmParameters.init(algorithmParameterSpec);
        EncryptedPrivateKeyInfo encinfo = new EncryptedPrivateKeyInfo(algorithmParameters, ciphertext);
        return encinfo.getEncoded();
    }

    public static PrivateKey getPasswordProtectedPrivateKey(byte[] derEncodedPkcs8byteArray, String password) throws IOException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidAlgorithmParameterException, InvalidKeyException {
        EncryptedPrivateKeyInfo encryptPKInfo = new EncryptedPrivateKeyInfo(derEncodedPkcs8byteArray);
        Cipher cipher = Cipher.getInstance(encryptPKInfo.getAlgName());
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password.toCharArray());
        SecretKeyFactory secFac = SecretKeyFactory.getInstance(encryptPKInfo.getAlgName());
        SecretKey pbeKey = secFac.generateSecret(pbeKeySpec);
        AlgorithmParameters algParams = encryptPKInfo.getAlgParameters();
        cipher.init(2, (Key)pbeKey, algParams);
        PKCS8EncodedKeySpec pkcs8KeySpec = encryptPKInfo.getKeySpec(cipher);
        KeyFactory kf = KeyFactory.getInstance(KeyPairGeneratorAlgorithm.RSA.getAlgorithm());
        return kf.generatePrivate(pkcs8KeySpec);
    }
}

