/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.key.writer;

import io.github.astrapi69.crypt.api.key.KeyFileFormat;
import io.github.astrapi69.crypt.api.key.KeyFormat;
import io.github.astrapi69.crypt.data.key.PrivateKeyExtensions;
import io.github.astrapi69.crypt.data.key.writer.KeyWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Objects;

public final class PrivateKeyWriter {
    private PrivateKeyWriter() {
    }

    public static void write(PrivateKey privateKey, File file) throws IOException {
        Objects.requireNonNull(file);
        PrivateKeyWriter.write(privateKey, new FileOutputStream(file));
    }

    public static void write(PrivateKey privateKey, OutputStream outputStream) throws IOException {
        Objects.requireNonNull(outputStream);
        byte[] privateKeyBytes = privateKey.getEncoded();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        outputStream.write(keySpec.getEncoded());
        outputStream.close();
    }

    public static void write(PrivateKey privateKey, OutputStream outputStream, KeyFileFormat fileFormat, KeyFormat keyFormat) throws IOException {
        Objects.requireNonNull(outputStream);
        byte[] privateKeyBytes = privateKey.getEncoded();
        switch (fileFormat) {
            case PEM: {
                if (keyFormat == null || keyFormat.equals((Object)KeyFormat.PKCS_8)) {
                    String privateKeyAsBase64String = PrivateKeyExtensions.toPemFormat(privateKey);
                    outputStream.write(privateKeyAsBase64String.getBytes(StandardCharsets.US_ASCII));
                    break;
                }
                if (keyFormat.equals((Object)KeyFormat.PKCS_1)) {
                    byte[] privateKeyPKCS1Formatted = PrivateKeyExtensions.toPKCS1Format(privateKey);
                    String pemFormat = PrivateKeyExtensions.fromPKCS1ToPemFormat(privateKeyPKCS1Formatted);
                    outputStream.write(pemFormat.getBytes(StandardCharsets.US_ASCII));
                    break;
                }
            }
            default: {
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
                outputStream.write(keySpec.getEncoded());
            }
        }
        outputStream.close();
    }

    public static void writeInPemFormat(PrivateKey privateKey, File file) throws IOException {
        Objects.requireNonNull(file);
        KeyWriter.writeInPemFormat(privateKey, file);
    }
}

