/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.key.writer;

import io.github.astrapi69.crypt.data.key.writer.KeyWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;

public final class PublicKeyWriter {
    private PublicKeyWriter() {
    }

    public static void write(PublicKey publicKey, File file) throws IOException {
        Objects.requireNonNull(file);
        PublicKeyWriter.write(publicKey, new FileOutputStream(file));
    }

    public static void write(PublicKey publicKey, OutputStream outputStream) throws IOException {
        Objects.requireNonNull(outputStream);
        byte[] publicKeyBytes = publicKey.getEncoded();
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
        outputStream.write(keySpec.getEncoded());
        outputStream.close();
    }

    public static void writeInPemFormat(PublicKey publicKey, File file) throws IOException {
        Objects.requireNonNull(file);
        KeyWriter.writeInPemFormat(publicKey, file);
    }
}

