/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.model;

import io.github.astrapi69.crypt.api.algorithm.Algorithm;
import io.github.astrapi69.crypt.data.model.CryptObjectDecorator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class CryptModel<C, K, T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Algorithm algorithm;
    private C cipher;
    private List<CryptObjectDecorator<T>> decorators;
    private boolean initialized;
    private Integer iterationCount;
    private K key;
    private int operationMode;
    private byte[] salt;

    public static <C, K, T> CryptModel<C, K, T> of(K key) {
        return ((CryptModelBuilder)CryptModel.builder().key(key)).build();
    }

    @Generated
    protected CryptModel(CryptModelBuilder<C, K, T, ?, ?> b) {
        this.algorithm = b.algorithm;
        this.cipher = b.cipher;
        this.decorators = switch (b.decorators == null ? 0 : b.decorators.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.decorators.get(0));
            default -> Collections.unmodifiableList(new ArrayList(b.decorators));
        };
        this.initialized = b.initialized;
        this.iterationCount = b.iterationCount;
        this.key = b.key;
        this.operationMode = b.operationMode;
        this.salt = b.salt;
    }

    @Generated
    public static <C, K, T> CryptModelBuilder<C, K, T, ?, ?> builder() {
        return new CryptModelBuilderImpl();
    }

    @Generated
    public CryptModelBuilder<C, K, T, ?, ?> toBuilder() {
        return new CryptModelBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    @Generated
    public C getCipher() {
        return this.cipher;
    }

    @Generated
    public List<CryptObjectDecorator<T>> getDecorators() {
        return this.decorators;
    }

    @Generated
    public boolean isInitialized() {
        return this.initialized;
    }

    @Generated
    public Integer getIterationCount() {
        return this.iterationCount;
    }

    @Generated
    public K getKey() {
        return this.key;
    }

    @Generated
    public int getOperationMode() {
        return this.operationMode;
    }

    @Generated
    public byte[] getSalt() {
        return this.salt;
    }

    @Generated
    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    @Generated
    public void setCipher(C cipher) {
        this.cipher = cipher;
    }

    @Generated
    public void setDecorators(List<CryptObjectDecorator<T>> decorators) {
        this.decorators = decorators;
    }

    @Generated
    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Generated
    public void setIterationCount(Integer iterationCount) {
        this.iterationCount = iterationCount;
    }

    @Generated
    public void setKey(K key) {
        this.key = key;
    }

    @Generated
    public void setOperationMode(int operationMode) {
        this.operationMode = operationMode;
    }

    @Generated
    public void setSalt(byte[] salt) {
        this.salt = salt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CryptModel)) {
            return false;
        }
        CryptModel other = (CryptModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isInitialized() != other.isInitialized()) {
            return false;
        }
        if (this.getOperationMode() != other.getOperationMode()) {
            return false;
        }
        Integer this$iterationCount = this.getIterationCount();
        Integer other$iterationCount = other.getIterationCount();
        if (this$iterationCount == null ? other$iterationCount != null : !((Object)this$iterationCount).equals(other$iterationCount)) {
            return false;
        }
        Algorithm this$algorithm = this.getAlgorithm();
        Algorithm other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
            return false;
        }
        C this$cipher = this.getCipher();
        C other$cipher = other.getCipher();
        if (this$cipher == null ? other$cipher != null : !this$cipher.equals(other$cipher)) {
            return false;
        }
        List<CryptObjectDecorator<T>> this$decorators = this.getDecorators();
        List<CryptObjectDecorator<T>> other$decorators = other.getDecorators();
        if (this$decorators == null ? other$decorators != null : !((Object)this$decorators).equals(other$decorators)) {
            return false;
        }
        K this$key = this.getKey();
        K other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        return Arrays.equals(this.getSalt(), other.getSalt());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CryptModel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isInitialized() ? 79 : 97);
        result = result * 59 + this.getOperationMode();
        Integer $iterationCount = this.getIterationCount();
        result = result * 59 + ($iterationCount == null ? 43 : ((Object)$iterationCount).hashCode());
        Algorithm $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        C $cipher = this.getCipher();
        result = result * 59 + ($cipher == null ? 43 : $cipher.hashCode());
        List<CryptObjectDecorator<T>> $decorators = this.getDecorators();
        result = result * 59 + ($decorators == null ? 43 : ((Object)$decorators).hashCode());
        K $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        result = result * 59 + Arrays.hashCode(this.getSalt());
        return result;
    }

    @Generated
    public String toString() {
        return "CryptModel(algorithm=" + this.getAlgorithm() + ", cipher=" + this.getCipher() + ", decorators=" + this.getDecorators() + ", initialized=" + this.isInitialized() + ", iterationCount=" + this.getIterationCount() + ", key=" + this.getKey() + ", operationMode=" + this.getOperationMode() + ", salt=" + Arrays.toString(this.getSalt()) + ")";
    }

    @Generated
    public CryptModel() {
    }

    @Generated
    public CryptModel(Algorithm algorithm, C cipher, List<CryptObjectDecorator<T>> decorators, boolean initialized, Integer iterationCount, K key, int operationMode, byte[] salt) {
        this.algorithm = algorithm;
        this.cipher = cipher;
        this.decorators = decorators;
        this.initialized = initialized;
        this.iterationCount = iterationCount;
        this.key = key;
        this.operationMode = operationMode;
        this.salt = salt;
    }

    @Generated
    public static abstract class CryptModelBuilder<C, K, T, C2 extends CryptModel<C, K, T>, B extends CryptModelBuilder<C, K, T, C2, B>> {
        @Generated
        private Algorithm algorithm;
        @Generated
        private C cipher;
        @Generated
        private ArrayList<CryptObjectDecorator<T>> decorators;
        @Generated
        private boolean initialized;
        @Generated
        private Integer iterationCount;
        @Generated
        private K key;
        @Generated
        private int operationMode;
        @Generated
        private byte[] salt;

        @Generated
        protected B $fillValuesFrom(C2 instance) {
            CryptModelBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static <C, K, T> void $fillValuesFromInstanceIntoBuilder(CryptModel<C, K, T> instance, CryptModelBuilder<C, K, T, ?, ?> b) {
            b.algorithm(instance.algorithm);
            b.cipher(instance.cipher);
            b.decorators(instance.decorators == null ? Collections.emptyList() : instance.decorators);
            b.initialized(instance.initialized);
            b.iterationCount(instance.iterationCount);
            b.key(instance.key);
            b.operationMode(instance.operationMode);
            b.salt(instance.salt);
        }

        @Generated
        public B algorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            return this.self();
        }

        @Generated
        public B cipher(C cipher) {
            this.cipher = cipher;
            return this.self();
        }

        @Generated
        public B decorator(CryptObjectDecorator<T> decorator) {
            if (this.decorators == null) {
                this.decorators = new ArrayList();
            }
            this.decorators.add(decorator);
            return this.self();
        }

        @Generated
        public B decorators(Collection<? extends CryptObjectDecorator<T>> decorators) {
            if (decorators == null) {
                throw new NullPointerException("decorators cannot be null");
            }
            if (this.decorators == null) {
                this.decorators = new ArrayList();
            }
            this.decorators.addAll(decorators);
            return this.self();
        }

        @Generated
        public B clearDecorators() {
            if (this.decorators != null) {
                this.decorators.clear();
            }
            return this.self();
        }

        @Generated
        public B initialized(boolean initialized) {
            this.initialized = initialized;
            return this.self();
        }

        @Generated
        public B iterationCount(Integer iterationCount) {
            this.iterationCount = iterationCount;
            return this.self();
        }

        @Generated
        public B key(K key) {
            this.key = key;
            return this.self();
        }

        @Generated
        public B operationMode(int operationMode) {
            this.operationMode = operationMode;
            return this.self();
        }

        @Generated
        public B salt(byte[] salt) {
            this.salt = salt;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C2 build();

        @Generated
        public String toString() {
            return "CryptModel.CryptModelBuilder(algorithm=" + this.algorithm + ", cipher=" + this.cipher + ", decorators=" + this.decorators + ", initialized=" + this.initialized + ", iterationCount=" + this.iterationCount + ", key=" + this.key + ", operationMode=" + this.operationMode + ", salt=" + Arrays.toString(this.salt) + ")";
        }
    }

    @Generated
    private static final class CryptModelBuilderImpl<C, K, T>
    extends CryptModelBuilder<C, K, T, CryptModel<C, K, T>, CryptModelBuilderImpl<C, K, T>> {
        @Generated
        private CryptModelBuilderImpl() {
        }

        @Override
        @Generated
        protected CryptModelBuilderImpl<C, K, T> self() {
            return this;
        }

        @Override
        @Generated
        public CryptModel<C, K, T> build() {
            return new CryptModel(this);
        }
    }
}

