/*
 * Decompiled with CFR 0.152.
 */
package io.github.astrapi69.crypt.data.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.bouncycastle.asn1.x500.X500Name;

public class DistinguishedNameInfo {
    public static final String SHOTCUT_COUNTRY_CODE = "C";
    public static final String SHORTCUT_STATE = "ST";
    public static final String SHORTCUT_LOCATION = "L";
    public static final String SHORTCUT_ORGANISATION = "O";
    public static final String SHORTCUT_ORGANISATION_UNIT = "OU";
    public static final String SHORTCUT_COMMON_NAME = "CN";
    private final String commonName;
    private final String countryCode;
    private final String location;
    private final String organisation;
    private final String organisationUnit;
    private final String state;

    public static DistinguishedNameInfo toDistinguishedNameInfo(String representableString) {
        String[] parts;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String part : parts = representableString.split(",")) {
            String[] keyValue = part.trim().split("=");
            if (keyValue.length != 2) continue;
            map.put(keyValue[0].trim(), keyValue[1].trim());
        }
        Object distinguishedNameInfo = ((DistinguishedNameInfoBuilder)((DistinguishedNameInfoBuilder)((DistinguishedNameInfoBuilder)((DistinguishedNameInfoBuilder)((DistinguishedNameInfoBuilder)((DistinguishedNameInfoBuilder)DistinguishedNameInfo.builder().countryCode((String)map.get(SHOTCUT_COUNTRY_CODE))).state((String)map.get(SHORTCUT_STATE))).location((String)map.get(SHORTCUT_LOCATION))).organisation((String)map.get(SHORTCUT_ORGANISATION))).organisationUnit((String)map.get(SHORTCUT_ORGANISATION_UNIT))).commonName((String)map.get(SHORTCUT_COMMON_NAME))).build();
        return distinguishedNameInfo;
    }

    public String toRepresentableString() {
        return DistinguishedNameInfo.toRepresentableString(this);
    }

    public X500Name toX500Name() {
        return new X500Name(this.toRepresentableString());
    }

    public static X500Name toX500Name(@NonNull DistinguishedNameInfo distinguishedNameInfo) {
        if (distinguishedNameInfo == null) {
            throw new NullPointerException("distinguishedNameInfo is marked non-null but is null");
        }
        return distinguishedNameInfo.toX500Name();
    }

    public static String toRepresentableString(DistinguishedNameInfo distinguishedNameInfo) {
        ArrayList<String> parts = new ArrayList<String>();
        DistinguishedNameInfo.addCertificateValue(parts, SHORTCUT_COMMON_NAME, distinguishedNameInfo.commonName);
        DistinguishedNameInfo.addCertificateValue(parts, SHORTCUT_ORGANISATION_UNIT, distinguishedNameInfo.organisationUnit);
        DistinguishedNameInfo.addCertificateValue(parts, SHORTCUT_ORGANISATION, distinguishedNameInfo.organisation);
        DistinguishedNameInfo.addCertificateValue(parts, SHORTCUT_LOCATION, distinguishedNameInfo.location);
        DistinguishedNameInfo.addCertificateValue(parts, SHORTCUT_STATE, distinguishedNameInfo.state);
        DistinguishedNameInfo.addCertificateValue(parts, SHOTCUT_COUNTRY_CODE, distinguishedNameInfo.countryCode);
        return String.join((CharSequence)",", parts);
    }

    private static void addCertificateValue(List<String> parts, String key, String certificateValue) {
        if (certificateValue != null && !certificateValue.isEmpty()) {
            parts.add(key + "=" + certificateValue);
        }
    }

    @Generated
    protected DistinguishedNameInfo(DistinguishedNameInfoBuilder<?, ?> b) {
        this.commonName = b.commonName;
        this.countryCode = b.countryCode;
        this.location = b.location;
        this.organisation = b.organisation;
        this.organisationUnit = b.organisationUnit;
        this.state = b.state;
    }

    @Generated
    public static DistinguishedNameInfoBuilder<?, ?> builder() {
        return new DistinguishedNameInfoBuilderImpl();
    }

    @Generated
    public DistinguishedNameInfoBuilder<?, ?> toBuilder() {
        return new DistinguishedNameInfoBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getCommonName() {
        return this.commonName;
    }

    @Generated
    public String getCountryCode() {
        return this.countryCode;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public String getOrganisation() {
        return this.organisation;
    }

    @Generated
    public String getOrganisationUnit() {
        return this.organisationUnit;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DistinguishedNameInfo)) {
            return false;
        }
        DistinguishedNameInfo other = (DistinguishedNameInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$commonName = this.getCommonName();
        String other$commonName = other.getCommonName();
        if (this$commonName == null ? other$commonName != null : !this$commonName.equals(other$commonName)) {
            return false;
        }
        String this$countryCode = this.getCountryCode();
        String other$countryCode = other.getCountryCode();
        if (this$countryCode == null ? other$countryCode != null : !this$countryCode.equals(other$countryCode)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        String this$organisation = this.getOrganisation();
        String other$organisation = other.getOrganisation();
        if (this$organisation == null ? other$organisation != null : !this$organisation.equals(other$organisation)) {
            return false;
        }
        String this$organisationUnit = this.getOrganisationUnit();
        String other$organisationUnit = other.getOrganisationUnit();
        if (this$organisationUnit == null ? other$organisationUnit != null : !this$organisationUnit.equals(other$organisationUnit)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        return !(this$state == null ? other$state != null : !this$state.equals(other$state));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DistinguishedNameInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $commonName = this.getCommonName();
        result = result * 59 + ($commonName == null ? 43 : $commonName.hashCode());
        String $countryCode = this.getCountryCode();
        result = result * 59 + ($countryCode == null ? 43 : $countryCode.hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        String $organisation = this.getOrganisation();
        result = result * 59 + ($organisation == null ? 43 : $organisation.hashCode());
        String $organisationUnit = this.getOrganisationUnit();
        result = result * 59 + ($organisationUnit == null ? 43 : $organisationUnit.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DistinguishedNameInfo(commonName=" + this.getCommonName() + ", countryCode=" + this.getCountryCode() + ", location=" + this.getLocation() + ", organisation=" + this.getOrganisation() + ", organisationUnit=" + this.getOrganisationUnit() + ", state=" + this.getState() + ")";
    }

    @Generated
    public DistinguishedNameInfo(String commonName, String countryCode, String location, String organisation, String organisationUnit, String state) {
        this.commonName = commonName;
        this.countryCode = countryCode;
        this.location = location;
        this.organisation = organisation;
        this.organisationUnit = organisationUnit;
        this.state = state;
    }

    @Generated
    public static abstract class DistinguishedNameInfoBuilder<C extends DistinguishedNameInfo, B extends DistinguishedNameInfoBuilder<C, B>> {
        @Generated
        private String commonName;
        @Generated
        private String countryCode;
        @Generated
        private String location;
        @Generated
        private String organisation;
        @Generated
        private String organisationUnit;
        @Generated
        private String state;

        @Generated
        protected B $fillValuesFrom(C instance) {
            DistinguishedNameInfoBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DistinguishedNameInfo instance, DistinguishedNameInfoBuilder<?, ?> b) {
            b.commonName(instance.commonName);
            b.countryCode(instance.countryCode);
            b.location(instance.location);
            b.organisation(instance.organisation);
            b.organisationUnit(instance.organisationUnit);
            b.state(instance.state);
        }

        @Generated
        public B commonName(String commonName) {
            this.commonName = commonName;
            return this.self();
        }

        @Generated
        public B countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this.self();
        }

        @Generated
        public B location(String location) {
            this.location = location;
            return this.self();
        }

        @Generated
        public B organisation(String organisation) {
            this.organisation = organisation;
            return this.self();
        }

        @Generated
        public B organisationUnit(String organisationUnit) {
            this.organisationUnit = organisationUnit;
            return this.self();
        }

        @Generated
        public B state(String state) {
            this.state = state;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "DistinguishedNameInfo.DistinguishedNameInfoBuilder(commonName=" + this.commonName + ", countryCode=" + this.countryCode + ", location=" + this.location + ", organisation=" + this.organisation + ", organisationUnit=" + this.organisationUnit + ", state=" + this.state + ")";
        }
    }

    @Generated
    private static final class DistinguishedNameInfoBuilderImpl
    extends DistinguishedNameInfoBuilder<DistinguishedNameInfo, DistinguishedNameInfoBuilderImpl> {
        @Generated
        private DistinguishedNameInfoBuilderImpl() {
        }

        @Override
        @Generated
        protected DistinguishedNameInfoBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DistinguishedNameInfo build() {
            return new DistinguishedNameInfo(this);
        }
    }
}

